/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.UIntIndexer;

public class UIntArrayIndexer
extends UIntIndexer {
    protected int[] array;

    public UIntArrayIndexer(int[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public UIntArrayIndexer(int[] array, long ... sizes) {
        this(array, sizes, UIntArrayIndexer.strides(sizes));
    }

    public UIntArrayIndexer(int[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public int[] array() {
        return this.array;
    }

    @Override
    public long get(long i) {
        return (long)this.array[(int)i] & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long i, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = (long)this.array[(int)i * (int)this.strides[0] + n] & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public long get(long i, long j) {
        return (long)this.array[(int)i * (int)this.strides[0] + (int)j] & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long i, long j, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = (long)this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public long get(long i, long j, long k) {
        return (long)this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] & 0xFFFFFFFFL;
    }

    @Override
    public long get(long ... indices) {
        return (long)this.array[(int)this.index(indices)] & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long[] indices, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = (long)this.array[(int)this.index(indices) + n] & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public UIntIndexer put(long i, long n) {
        this.array[(int)i] = (int)n;
        return this;
    }

    @Override
    public UIntIndexer put(long i, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = (int)m[offset + n];
        }
        return this;
    }

    @Override
    public UIntIndexer put(long i, long j, long n) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = (int)n;
        return this;
    }

    @Override
    public UIntIndexer put(long i, long j, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = (int)m[offset + n];
        }
        return this;
    }

    @Override
    public UIntIndexer put(long i, long j, long k, long n) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = (int)n;
        return this;
    }

    @Override
    public UIntIndexer put(long[] indices, long n) {
        this.array[(int)this.index((long[])indices)] = (int)n;
        return this;
    }

    @Override
    public UIntIndexer put(long[] indices, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = (int)m[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

