/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.internal.memory;

import lombok.NonNull;
import org.nd4j.autodiff.samediff.internal.SessionMemMgr;
import org.nd4j.autodiff.samediff.internal.memory.AbstractMemoryMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayCloseMemoryMgr
extends AbstractMemoryMgr
implements SessionMemMgr {
    private static final Logger log = LoggerFactory.getLogger(ArrayCloseMemoryMgr.class);

    @Override
    public INDArray allocate(boolean detached, DataType dataType, long ... shape) {
        return Nd4j.createUninitialized(dataType, shape);
    }

    @Override
    public INDArray allocate(boolean detached, LongShapeDescriptor descriptor) {
        return Nd4j.create(descriptor, false);
    }

    @Override
    public void release(@NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (!array.wasClosed() && array.closeable()) {
            array.close();
            log.trace("Closed array (deallocated) - id={}", (Object)array.getId());
        }
    }

    @Override
    public void close() {
    }
}

