/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.io.AbstractFileResolvingResource;
import org.nd4j.common.io.Assert;
import org.nd4j.common.io.ClassUtils;
import org.nd4j.common.io.ObjectUtils;
import org.nd4j.common.io.Resource;
import org.nd4j.common.io.StringUtils;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        Assert.notNull(path, "Path must not be null");
        String pathToUse = StringUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassPathResource(String path, Class<?> clazz) {
        Assert.notNull(path, "Path must not be null");
        this.path = StringUtils.cleanPath(path);
        this.clazz = clazz;
    }

    protected ClassPathResource(String path, ClassLoader classLoader, Class<?> clazz) {
        this.path = StringUtils.cleanPath(path);
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : this.clazz.getClassLoader();
    }

    @Override
    public File getFile() throws IOException {
        try {
            return super.getFile();
        }
        catch (FileNotFoundException e) {
            return this.getTempFileFromArchive();
        }
    }

    public File getTempFileFromArchive() throws IOException {
        return this.getTempFileFromArchive(null);
    }

    public File getTempFileFromArchive(File rootDirectory) throws IOException {
        InputStream is = this.getInputStream();
        File tmpFile = rootDirectory != null ? new File(rootDirectory, FilenameUtils.getName(this.path)) : Files.createTempFile(FilenameUtils.getName(this.path), "tmp", new FileAttribute[0]).toFile();
        tmpFile.deleteOnExit();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
        IOUtils.copy(is, (OutputStream)bos);
        bos.flush();
        bos.close();
        return tmpFile;
    }

    public void copyDirectory(File destination) throws IOException {
        block24: {
            File source;
            URL url;
            block23: {
                ZipFile zipFile;
                block22: {
                    Preconditions.checkState(destination.exists() && destination.isDirectory(), "Destination directory must exist and be a directory: %s", (Object)destination);
                    url = this.getUrl();
                    if (!ClassPathResource.isJarURL(url)) break block23;
                    InputStream stream = null;
                    zipFile = null;
                    try {
                        GetStreamFromZip getStreamFromZip = new GetStreamFromZip(url, this.path).invoke();
                        ZipEntry entry = getStreamFromZip.getEntry();
                        stream = getStreamFromZip.getStream();
                        zipFile = getStreamFromZip.getZipFile();
                        Preconditions.checkState(entry.isDirectory(), "Source must be a directory: %s", (Object)entry.getName());
                        String pathNoSlash = this.path;
                        if (pathNoSlash.endsWith("/") || pathNoSlash.endsWith("\\")) {
                            pathNoSlash = pathNoSlash.substring(0, pathNoSlash.length() - 1);
                        }
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry e = entries.nextElement();
                            String name = e.getName();
                            if (!name.startsWith(pathNoSlash) || name.length() <= pathNoSlash.length() || name.charAt(pathNoSlash.length()) != '/' && name.charAt(pathNoSlash.length()) != '\\') continue;
                            String relativePath = name.substring(this.path.length());
                            File extractTo = new File(destination, relativePath);
                            if (e.isDirectory()) {
                                extractTo.mkdirs();
                                continue;
                            }
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(extractTo));
                            Throwable throwable = null;
                            try {
                                InputStream is = ClassPathResource.getInputStream(name, this.clazz, this.classLoader);
                                IOUtils.copy(is, (OutputStream)bos);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (bos == null) continue;
                                if (throwable != null) {
                                    try {
                                        bos.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                bos.close();
                            }
                        }
                        stream.close();
                        zipFile.close();
                        if (stream == null) break block22;
                    }
                    catch (Exception e) {
                        try {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                IOUtils.closeQuietly(stream);
                            }
                            if (zipFile != null) {
                                IOUtils.closeQuietly(zipFile);
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(stream);
                }
                if (zipFile != null) {
                    IOUtils.closeQuietly((Closeable)zipFile);
                }
                break block24;
            }
            try {
                source = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException("Error converting URL to a URI - path may be invalid? Path=" + url);
            }
            Preconditions.checkState(source.isDirectory(), "Source must be a directory: %s", (Object)source);
            Preconditions.checkState(destination.exists() && destination.isDirectory(), "Destination must be a directory and must exist: %s", (Object)destination);
            FileUtils.copyDirectory(source, destination);
        }
    }

    @Override
    public boolean exists() {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        return url != null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return ClassPathResource.getInputStream(this.path, this.clazz, this.classLoader);
    }

    private static InputStream getInputStream(String path, Class<?> clazz, ClassLoader classLoader) throws IOException {
        InputStream is = clazz != null ? clazz.getResourceAsStream(path) : classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(path + " cannot be opened because it does not exist");
        }
        if (is instanceof BufferedInputStream) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = StringUtils.applyRelativePath(this.path, relativePath);
        return new ClassPathResource(pathToUse, this.classLoader, this.clazz);
    }

    @Override
    public String getFilename() {
        return StringUtils.getFilename(this.path);
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder("class path resource [");
        String pathToUse = this.path;
        if (this.clazz != null && !pathToUse.startsWith("/")) {
            builder.append(ClassUtils.classPackageAsResourcePath(this.clazz));
            builder.append('/');
        }
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        builder.append(pathToUse);
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClassPathResource)) {
            return false;
        }
        ClassPathResource otherRes = (ClassPathResource)obj;
        return this.path.equals(otherRes.path) && ObjectUtils.nullSafeEquals(this.classLoader, otherRes.classLoader) && ObjectUtils.nullSafeEquals(this.clazz, otherRes.clazz);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    private URL getUrl() {
        URL url;
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null) {
            loader = ClassPathResource.class.getClassLoader();
        }
        if ((url = loader.getResource(this.path)) == null) {
            if (this.path.startsWith("/") ? (url = loader.getResource(this.path.replaceFirst("[\\\\/]", ""))) != null : (url = loader.getResource("/" + this.path)) != null) {
                return url;
            }
            throw new IllegalStateException("Resource '" + this.path + "' cannot be found.");
        }
        return url;
    }

    private static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol) || "code-source".equals(protocol) && url.getPath().contains("!/");
    }

    private URL extractActualUrl(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException var5) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL("file:" + jarFile);
            }
        }
        return jarUrl;
    }

    private class GetStreamFromZip {
        private URL url;
        private ZipFile zipFile;
        private ZipEntry entry;
        private InputStream stream;
        private String resourceName;

        public GetStreamFromZip(URL url, String resourceName) {
            this.url = url;
            this.resourceName = resourceName;
        }

        public URL getUrl() {
            return this.url;
        }

        public ZipFile getZipFile() {
            return this.zipFile;
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public GetStreamFromZip invoke() throws IOException {
            this.url = ClassPathResource.this.extractActualUrl(this.url);
            this.zipFile = new ZipFile(this.url.getFile());
            this.entry = this.zipFile.getEntry(this.resourceName);
            if (this.entry == null) {
                if (this.resourceName.startsWith("/")) {
                    this.entry = this.zipFile.getEntry(this.resourceName.replaceFirst("/", ""));
                    if (this.entry == null) {
                        throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                    }
                } else {
                    throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                }
            }
            this.stream = this.zipFile.getInputStream(this.entry);
            return this;
        }
    }
}

