/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nd4j.common.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    private static final Logger log = LoggerFactory.getLogger(Downloader.class);
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_READ_TIMEOUT = 60000;

    private Downloader() {
    }

    public static void download(String name, URL url, File f, String targetMD5, int maxTries) throws IOException {
        Downloader.download(name, url, f, targetMD5, maxTries, 60000, 60000);
    }

    public static void download(String name, URL url, File f, String targetMD5, int maxTries, int connectionTimeout, int readTimeout) throws IOException {
        Downloader.download(name, url, f, targetMD5, maxTries, 0, connectionTimeout, readTimeout);
    }

    private static void download(String name, URL url, File f, String targetMD5, int maxTries, int attempt, int connectionTimeout, int readTimeout) throws IOException {
        boolean isCorrectFile;
        boolean bl = isCorrectFile = f.exists() && f.isFile() && Downloader.checkMD5OfFile(targetMD5, f);
        if (attempt < maxTries) {
            if (!isCorrectFile) {
                FileUtils.copyURLToFile(url, f, connectionTimeout, readTimeout);
                if (!Downloader.checkMD5OfFile(targetMD5, f)) {
                    f.delete();
                    Downloader.download(name, url, f, targetMD5, maxTries, attempt + 1, connectionTimeout, readTimeout);
                }
            }
        } else if (!isCorrectFile) {
            throw new IOException("Could not download " + name + " from " + url + "\n properly despite trying " + maxTries + " times, check your connection.");
        }
    }

    public static void downloadAndExtract(String name, URL url, File f, File extractToDir, String targetMD5, int maxTries) throws IOException {
        Downloader.downloadAndExtract(name, url, f, extractToDir, targetMD5, maxTries, 60000, 60000);
    }

    public static void downloadAndExtract(String name, URL url, File f, File extractToDir, String targetMD5, int maxTries, int connectionTimeout, int readTimeout) throws IOException {
        Downloader.downloadAndExtract(0, maxTries, name, url, f, extractToDir, targetMD5, connectionTimeout, readTimeout);
    }

    private static void downloadAndExtract(int attempt, int maxTries, String name, URL url, File f, File extractToDir, String targetMD5, int connectionTimeout, int readTimeout) throws IOException {
        boolean isCorrectFile;
        boolean bl = isCorrectFile = f.exists() && f.isFile() && Downloader.checkMD5OfFile(targetMD5, f);
        if (attempt < maxTries) {
            if (!isCorrectFile) {
                FileUtils.copyURLToFile(url, f, connectionTimeout, readTimeout);
                if (!Downloader.checkMD5OfFile(targetMD5, f)) {
                    f.delete();
                    Downloader.downloadAndExtract(attempt + 1, maxTries, name, url, f, extractToDir, targetMD5, connectionTimeout, readTimeout);
                }
            }
            try {
                ArchiveUtils.unzipFileTo(f.getAbsolutePath(), extractToDir.getAbsolutePath(), false);
            }
            catch (Throwable t) {
                log.warn("Error extracting {} files from file {} - retrying...", name, f.getAbsolutePath(), t);
                f.delete();
                Downloader.downloadAndExtract(attempt + 1, maxTries, name, url, f, extractToDir, targetMD5, connectionTimeout, readTimeout);
            }
        } else if (!isCorrectFile) {
            throw new IOException("Could not download and extract " + name + " from " + url.getPath() + "\n properly despite trying " + maxTries + " times, check your connection. File info:\nTarget MD5: " + targetMD5 + "\nHash matches: " + Downloader.checkMD5OfFile(targetMD5, f) + "\nIs valid file: " + f.isFile());
        }
    }

    public static boolean checkMD5OfFile(String targetMD5, File file) throws IOException {
        FileInputStream in = FileUtils.openInputStream(file);
        String trueMd5 = DigestUtils.md5Hex(in);
        IOUtils.closeQuietly(in);
        return targetMD5.equals(trueMd5);
    }
}

