/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.evaluation.serde;

import java.io.IOException;
import org.nd4j.evaluation.classification.ROC;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.databind.jsontype.TypeSerializer;

public class ROCSerializer
extends JsonSerializer<ROC> {
    @Override
    public void serialize(ROC roc, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        boolean empty;
        boolean bl = empty = roc.getExampleCount() == 0;
        if (roc.isExact() && !empty) {
            roc.calculateAUC();
            roc.calculateAUCPR();
        }
        jsonGenerator.writeNumberField("thresholdSteps", roc.getThresholdSteps());
        jsonGenerator.writeNumberField("countActualPositive", roc.getCountActualPositive());
        jsonGenerator.writeNumberField("countActualNegative", roc.getCountActualNegative());
        jsonGenerator.writeObjectField("counts", roc.getCounts());
        if (!empty) {
            jsonGenerator.writeNumberField("auc", roc.calculateAUC());
            jsonGenerator.writeNumberField("auprc", roc.calculateAUCPR());
        }
        if (roc.isExact() && !empty) {
            jsonGenerator.writeObjectField("rocCurve", roc.getRocCurve());
            jsonGenerator.writeObjectField("prCurve", roc.getPrecisionRecallCurve());
        }
        jsonGenerator.writeBooleanField("isExact", roc.isExact());
        jsonGenerator.writeNumberField("exampleCount", roc.getExampleCount());
        jsonGenerator.writeBooleanField("rocRemoveRedundantPts", roc.isRocRemoveRedundantPts());
    }

    @Override
    public void serializeWithType(ROC value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject(value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject(value, gen);
    }
}

