/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.concurrency;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nd4j.jita.allocator.concurrency.Lock;
import org.nd4j.jita.allocator.impl.AllocationShape;

public class RRWLock
implements Lock {
    private ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock externalsLock = new ReentrantReadWriteLock();
    private Map<Object, ReentrantReadWriteLock> objectLocks = new ConcurrentHashMap<Object, ReentrantReadWriteLock>();

    @Override
    public void attachObject(Object object) {
        if (!this.objectLocks.containsKey(object)) {
            this.objectLocks.put(object, new ReentrantReadWriteLock());
        }
    }

    @Override
    public void detachObject(Object object) {
        this.objectLocks.remove(object);
    }

    @Override
    public void globalReadLock() {
        this.globalLock.readLock().lock();
    }

    @Override
    public void globalReadUnlock() {
        this.globalLock.readLock().unlock();
    }

    @Override
    public void globalWriteLock() {
        this.globalLock.writeLock().lock();
    }

    @Override
    public void globalWriteUnlock() {
        this.globalLock.writeLock().unlock();
    }

    @Override
    public void objectReadLock(Object object) {
        this.objectLocks.get(object).readLock().lock();
    }

    @Override
    public void objectReadUnlock(Object object) {
        this.objectLocks.get(object).readLock().unlock();
    }

    @Override
    public void objectWriteLock(Object object) {
        this.objectLocks.get(object).writeLock().lock();
    }

    @Override
    public void objectWriteUnlock(Object object) {
        this.objectLocks.get(object).writeLock().unlock();
    }

    @Override
    public void shapeReadLock(Object object, AllocationShape shape) {
        this.objectReadLock(object);
    }

    @Override
    public void shapeReadUnlock(Object object, AllocationShape shape) {
        this.objectReadUnlock(object);
    }

    @Override
    public void shapeWriteLock(Object object, AllocationShape shape) {
        this.objectReadLock(object);
    }

    @Override
    public void shapeWriteUnlock(Object object, AllocationShape shape) {
        this.objectReadUnlock(object);
    }

    @Override
    public void externalsReadLock() {
        this.externalsLock.readLock().lock();
    }

    @Override
    public void externalsReadUnlock() {
        this.externalsLock.readLock().unlock();
    }

    @Override
    public void externalsWriteLock() {
        this.externalsLock.writeLock().lock();
    }

    @Override
    public void externalsWriteUnlock() {
        this.externalsLock.writeLock().unlock();
    }
}

