/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.constant;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.common.primitives.Pair;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.constant.ConstantProtector;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedCudaShapeInfoProvider
extends BaseShapeInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(ProtectedCudaShapeInfoProvider.class);
    private AtomicAllocator allocator;
    private AtomicLong cacheHit = new AtomicLong(1L);
    private AtomicLong cacheMiss = new AtomicLong(1L);
    private Semaphore lock = new Semaphore(1);
    protected static final ConstantProtector protector = ConstantProtector.getInstance();
    private static ProtectedCudaShapeInfoProvider ourInstance = new ProtectedCudaShapeInfoProvider();

    private ProtectedCudaShapeInfoProvider() {
    }

    @Override
    public void purgeCache() {
        protector.purgeProtector();
    }

    public static ProtectedCudaShapeInfoProvider getInstance() {
        return ourInstance;
    }

    @Override
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long elementWiseStride, char order, DataType type, boolean empty) {
        long extras = ArrayOptionsHelper.setOptionBit(0L, type);
        if (empty) {
            extras = ArrayOptionsHelper.setOptionBit(extras, ArrayType.EMPTY);
        }
        return this.createShapeInformation(shape, stride, elementWiseStride, order, extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long elementWiseStride, char order, long extras) {
        long offset = 0L;
        if (elementWiseStride < 0L) {
            elementWiseStride = 0L;
        }
        Integer deviceId = AtomicAllocator.getInstance().getDeviceId();
        LongShapeDescriptor descriptor = new LongShapeDescriptor(shape, stride, offset, elementWiseStride, order, extras);
        if (!protector.containsDataBuffer((int)deviceId, descriptor)) {
            Pair<DataBuffer, long[]> buffer = null;
            ProtectedCudaShapeInfoProvider protectedCudaShapeInfoProvider = this;
            synchronized (protectedCudaShapeInfoProvider) {
                if (!protector.containsDataBuffer((int)deviceId, descriptor)) {
                    buffer = super.createShapeInformation(shape, stride, elementWiseStride, order, extras);
                    buffer.getFirst().setConstant(true);
                    protector.persistDataBuffer((int)deviceId, descriptor, buffer);
                    this.bytes.addAndGet(buffer.getFirst().length() * 8L * 2L);
                    this.cacheMiss.incrementAndGet();
                } else {
                    buffer = protector.getDataBuffer((int)deviceId, descriptor);
                }
            }
            return buffer;
        }
        this.cacheHit.incrementAndGet();
        return protector.getDataBuffer((int)deviceId, descriptor);
    }
}

