/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.workspace;

import java.util.Map;
import lombok.NonNull;
import org.nd4j.jita.workspace.CudaWorkspace;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.abstracts.DummyWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.DebugMode;
import org.nd4j.linalg.api.memory.provider.BasicWorkspaceManager;
import org.nd4j.linalg.factory.Nd4j;

public class CudaWorkspaceManager
extends BasicWorkspaceManager {
    protected MemoryWorkspace newWorkspace(WorkspaceConfiguration configuration) {
        return Nd4j.getWorkspaceManager().getDebugMode() == DebugMode.BYPASS_EVERYTHING ? new DummyWorkspace() : new CudaWorkspace(configuration);
    }

    protected MemoryWorkspace newWorkspace(WorkspaceConfiguration configuration, String id) {
        return Nd4j.getWorkspaceManager().getDebugMode() == DebugMode.BYPASS_EVERYTHING ? new DummyWorkspace() : new CudaWorkspace(configuration, id);
    }

    protected MemoryWorkspace newWorkspace(WorkspaceConfiguration configuration, String id, int deviceId) {
        return Nd4j.getWorkspaceManager().getDebugMode() == DebugMode.BYPASS_EVERYTHING ? new DummyWorkspace() : new CudaWorkspace(configuration, id, deviceId);
    }

    @Override
    public MemoryWorkspace createNewWorkspace(@NonNull WorkspaceConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.ensureThreadExistense();
        MemoryWorkspace workspace = this.newWorkspace(configuration);
        ((Map)this.backingMap.get()).put(workspace.getId(), workspace);
        if (Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.BYPASS_EVERYTHING) {
            this.pickReference(workspace);
        }
        return workspace;
    }

    @Override
    protected void pickReference(MemoryWorkspace w) {
        Nd4j.getDeallocatorService().pickObject(w);
    }

    @Override
    public MemoryWorkspace createNewWorkspace() {
        this.ensureThreadExistense();
        MemoryWorkspace workspace = this.newWorkspace(this.defaultConfiguration);
        ((Map)this.backingMap.get()).put(workspace.getId(), workspace);
        if (Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.BYPASS_EVERYTHING) {
            this.pickReference(workspace);
        }
        return workspace;
    }

    @Override
    public MemoryWorkspace createNewWorkspace(WorkspaceConfiguration configuration, String id) {
        this.ensureThreadExistense();
        MemoryWorkspace workspace = this.newWorkspace(configuration, id);
        ((Map)this.backingMap.get()).put(id, workspace);
        if (Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.BYPASS_EVERYTHING) {
            this.pickReference(workspace);
        }
        return workspace;
    }

    @Override
    public MemoryWorkspace createNewWorkspace(WorkspaceConfiguration configuration, String id, Integer deviceId) {
        this.ensureThreadExistense();
        MemoryWorkspace workspace = this.newWorkspace(configuration, id, deviceId);
        ((Map)this.backingMap.get()).put(id, workspace);
        if (Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.BYPASS_EVERYTHING) {
            this.pickReference(workspace);
        }
        return workspace;
    }

    @Override
    public MemoryWorkspace getWorkspaceForCurrentThread(@NonNull WorkspaceConfiguration configuration, @NonNull String id) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.ensureThreadExistense();
        MemoryWorkspace workspace = (MemoryWorkspace)((Map)this.backingMap.get()).get(id);
        if (workspace == null) {
            workspace = this.newWorkspace(configuration, id);
            ((Map)this.backingMap.get()).put(id, workspace);
            if (Nd4j.getWorkspaceManager().getDebugMode() != DebugMode.BYPASS_EVERYTHING) {
                this.pickReference(workspace);
            }
        }
        return workspace;
    }
}

