/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations.impl;

import lombok.NonNull;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.BaseActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.CubeBp;
import org.nd4j.linalg.api.ops.impl.transforms.same.Cube;
import org.nd4j.linalg.factory.Nd4j;

public class ActivationCube
extends BaseActivationFunction {
    @Override
    public INDArray getActivation(INDArray in, boolean training) {
        Nd4j.getExecutioner().execAndReturn(new Cube(in));
        return in;
    }

    @Override
    public Pair<INDArray, INDArray> backprop(@NonNull INDArray in, @NonNull INDArray epsilon) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (epsilon == null) {
            throw new NullPointerException("epsilon is marked non-null but is null");
        }
        this.assertShape(in, epsilon);
        Nd4j.getExecutioner().execAndReturn(new CubeBp(in, epsilon, in));
        return new Pair<INDArray, Object>(in, null);
    }

    public String toString() {
        return "cube";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationCube)) {
            return false;
        }
        ActivationCube other = (ActivationCube)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivationCube;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

