/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.iter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.iter.LinearIndexLookup;
import org.nd4j.linalg.api.shape.Shape;

public class NdIndexIterator
implements Iterator<long[]> {
    private int length = -1;
    private int i = 0;
    private long[] shape;
    private char order = (char)99;
    private boolean cache = false;
    private static Map<Pair<long[], Character>, LinearIndexLookup> lookupMap = new HashMap<Pair<long[], Character>, LinearIndexLookup>();
    private LinearIndexLookup lookup;

    public NdIndexIterator(int ... shape) {
        this('c', shape);
        this.cache = false;
    }

    public NdIndexIterator(long ... shape) {
        this('c', false, shape);
        this.cache = false;
    }

    public NdIndexIterator(char order, boolean cache, long ... shape) {
        this.shape = ArrayUtil.copy(shape);
        this.length = ArrayUtil.prod(shape);
        this.order = order;
        this.cache = cache;
        if (this.cache) {
            LinearIndexLookup lookup = lookupMap.get(new Pair<long[], Character>(shape, Character.valueOf(order)));
            if (lookup == null) {
                lookup = new LinearIndexLookup(shape, order);
                for (int i = 0; i < this.length; ++i) {
                    lookup.lookup(i);
                }
                lookupMap.put(new Pair<long[], Character>(shape, Character.valueOf(order)), lookup);
                this.lookup = lookup;
            } else {
                this.lookup = lookupMap.get(new Pair<long[], Character>(shape, Character.valueOf(order)));
            }
        }
    }

    public NdIndexIterator(char order, int ... shape) {
        this(order, false, ArrayUtil.toLongArray(shape));
    }

    public NdIndexIterator(char order, long ... shape) {
        this(order, false, shape);
    }

    @Override
    public boolean hasNext() {
        return this.i < this.length;
    }

    @Override
    public long[] next() {
        if (this.lookup != null) {
            return this.lookup.lookup(this.i++);
        }
        switch (this.order) {
            case 'c': {
                return Shape.ind2subC(this.shape, (long)this.i++);
            }
            case 'f': {
                return Shape.ind2sub(this.shape, (long)this.i++);
            }
        }
        throw new IllegalArgumentException("Illegal ordering " + this.order);
    }

    @Override
    public void remove() {
    }
}

