/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class BitCast
extends DynamicCustomOp {
    private DataType dtype;

    public BitCast() {
    }

    public BitCast(INDArray in, DataType dataType, INDArray out) {
        this(in, dataType.toInt(), out);
    }

    public BitCast(INDArray in, int dataType, INDArray out) {
        this.inputArguments.add(in);
        this.outputArguments.add(out);
        this.iArguments.add(Long.valueOf(dataType));
        this.dtype = DataType.fromInt(dataType);
    }

    public BitCast(INDArray in, DataType dataType) {
        this(in, dataType.toInt());
    }

    public BitCast(INDArray in, int dataType) {
        this.inputArguments.add(in);
        this.iArguments.add(Long.valueOf(dataType));
        this.dtype = DataType.fromInt(dataType);
    }

    public BitCast(SameDiff sameDiff, SDVariable in, SDVariable dataType) {
        super("", sameDiff, new SDVariable[]{in, dataType});
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        AttrValue t = nodeDef.getAttrOrDefault("type", null);
        DataType type = ArrayOptionsHelper.convertToDataType(t.getType());
        this.addIArgument(type.toInt());
        this.dtype = type;
    }

    @Override
    public String opName() {
        return "bitcast";
    }

    @Override
    public String tensorflowName() {
        return "Bitcast";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(this.dtype);
    }
}

