/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class FusedBatchNorm
extends DynamicCustomOp {
    private DataType outputDataType;

    public FusedBatchNorm() {
    }

    public FusedBatchNorm(@NonNull INDArray x, @NonNull INDArray scale, @NonNull INDArray offset, int dataFormat, int isTraining, INDArray yOut, INDArray batchMeanOut, INDArray batchMeanVar) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (scale == null) {
            throw new NullPointerException("scale is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.addInputArgument(x, scale, offset);
        this.addIArgument(dataFormat, isTraining);
        if (yOut != null && batchMeanOut != null && batchMeanVar != null) {
            this.addOutputArgument(yOut, batchMeanOut, batchMeanVar);
        }
        this.outputDataType = x.dataType();
    }

    public FusedBatchNorm(@NonNull SameDiff sameDiff, @NonNull SDVariable x, @NonNull SDVariable scale, @NonNull SDVariable offset, @NonNull SDVariable dataFormat, @NonNull SDVariable isTraining) {
        super("", sameDiff, new SDVariable[]{x, scale, offset, dataFormat, isTraining});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (scale == null) {
            throw new NullPointerException("scale is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (dataFormat == null) {
            throw new NullPointerException("dataFormat is marked non-null but is null");
        }
        if (isTraining == null) {
            throw new NullPointerException("isTraining is marked non-null but is null");
        }
        this.outputDataType = x.dataType();
    }

    public FusedBatchNorm(@NonNull SameDiff sameDiff, @NonNull SDVariable x, @NonNull SDVariable scale, @NonNull SDVariable offset, int dataFormat, int isTraining) {
        super("", sameDiff, new SDVariable[]{x, scale, offset});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (scale == null) {
            throw new NullPointerException("scale is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.addIArgument(dataFormat, isTraining);
        this.outputDataType = x.dataType();
    }

    @Override
    public String opName() {
        return "fused_batch_norm";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"FusedBatchNormV2", "FusedBatchNormV3"};
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        boolean isNchw = attributesForNode.containsKey("data_format") && attributesForNode.get("data_format").getS().toStringUtf8().equalsIgnoreCase("NCHW");
        boolean training = !attributesForNode.containsKey("is_training") ? true : attributesForNode.get("is_training").getB();
        this.addIArgument(isNchw ? 1 : 0);
        this.addIArgument(training ? 1 : 0);
        if (attributesForNode.containsKey("T")) {
            this.outputDataType = TFGraphMapper.convertType(attributesForNode.get("T").getType());
        }
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Arrays.asList(this.outputDataType == null ? DataType.FLOAT : this.outputDataType, this.outputDataType == null ? DataType.FLOAT : this.outputDataType, this.outputDataType == null ? DataType.FLOAT : this.outputDataType);
    }
}

