/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class Igamma
extends DynamicCustomOp {
    public Igamma(@NonNull INDArray n, @NonNull INDArray x) {
        if (n == null) {
            throw new NullPointerException("n is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        Preconditions.checkArgument(n.shape() != x.shape(), "Igamma: n and x must have the same shapes");
        this.addInputArgument(n, x);
    }

    public Igamma(@NonNull INDArray n, @NonNull INDArray x, INDArray output) {
        this(n, x);
        if (n == null) {
            throw new NullPointerException("n is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (output != null) {
            this.addOutputArgument(output);
        }
    }

    public Igamma(@NonNull SameDiff sameDiff, @NonNull SDVariable n, @NonNull SDVariable x) {
        super("", sameDiff, new SDVariable[]{n, x});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("n is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
    }

    @Override
    public String opName() {
        return "igamma";
    }

    @Override
    public String tensorflowName() {
        return "Igamma";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public Igamma() {
    }
}

