/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class LinearSolve
extends DynamicCustomOp {
    public LinearSolve(INDArray a, INDArray b, boolean adjoint) {
        this.addInputArgument(a, b);
        this.addBArgument(adjoint);
    }

    public LinearSolve(INDArray a, INDArray b) {
        this(a, b, false);
    }

    public LinearSolve(SameDiff sameDiff, SDVariable a, SDVariable b, SDVariable adjoint) {
        super(sameDiff, new SDVariable[]{a, b, adjoint});
    }

    public LinearSolve(SameDiff sameDiff, SDVariable a, SDVariable b, boolean adjoint) {
        super(sameDiff, new SDVariable[]{a, b});
        this.addBArgument(adjoint);
    }

    @Override
    public String opName() {
        return "solve";
    }

    @Override
    public String tensorflowName() {
        return "MatrixSolve";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        boolean adjoint = attributesForNode.containsKey("adjoint") ? attributesForNode.get("adjoint").getB() : false;
        this.addBArgument(adjoint);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        int n = this.args().length;
        Preconditions.checkState(dataTypes != null && dataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    public LinearSolve() {
    }
}

