/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class Roll
extends DynamicCustomOp {
    public Roll() {
    }

    public Roll(@NonNull INDArray input, @NonNull INDArray axes, @NonNull INDArray shifts) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (axes == null) {
            throw new NullPointerException("axes is marked non-null but is null");
        }
        if (shifts == null) {
            throw new NullPointerException("shifts is marked non-null but is null");
        }
        Preconditions.checkArgument(axes.rank() == shifts.rank(), "Roll: shifts and axes should be the same rank");
        Preconditions.checkArgument(axes.length() == shifts.length(), "Roll: shifts and axes should be the same length");
        this.addInputArgument(input, axes, shifts);
    }

    public Roll(@NonNull INDArray input, int shift) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.addInputArgument(input);
        this.addIArgument(shift);
    }

    public Roll(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable shift) {
        super("", sameDiff, new SDVariable[]{input, shift});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (shift == null) {
            throw new NullPointerException("shift is marked non-null but is null");
        }
    }

    public Roll(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable axes, @NonNull SDVariable shift) {
        super("", sameDiff, new SDVariable[]{input, axes, shift});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (axes == null) {
            throw new NullPointerException("axes is marked non-null but is null");
        }
        if (shift == null) {
            throw new NullPointerException("shift is marked non-null but is null");
        }
    }

    public Roll(@NonNull SameDiff sameDiff, @NonNull SDVariable input, int shift) {
        super("", sameDiff, new SDVariable[]{input});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.addIArgument(shift);
    }

    @Override
    public String opName() {
        return "roll";
    }

    @Override
    public String tensorflowName() {
        return "Roll";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

