/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.image;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ResizeArea
extends DynamicCustomOp {
    protected boolean alignCorners = false;
    protected Integer height = null;
    protected Integer width = null;

    public ResizeArea(@NonNull SameDiff sd, @NonNull SDVariable image, int height, int width, boolean alignCorners) {
        super(sd, image);
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.alignCorners = alignCorners;
        this.height = height;
        this.width = width;
        this.addArgs();
    }

    public ResizeArea(@NonNull INDArray x, INDArray z, int height, int width, boolean alignCorners) {
        super(new INDArray[]{x}, new INDArray[]{z});
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        this.alignCorners = alignCorners;
        this.height = height;
        this.width = width;
        this.addArgs();
    }

    @Override
    public String opName() {
        return "resize_area";
    }

    @Override
    public String tensorflowName() {
        return "ResizeArea";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        AttrValue attrC = attributesForNode.get("align_corners");
        this.alignCorners = attrC != null ? attrC.getB() : false;
        this.addArgs();
    }

    protected void addArgs() {
        this.iArguments.clear();
        if (this.height != null && this.width != null) {
            INDArray size = Nd4j.createFromArray(this.height, this.width);
            this.addInputArgument(size);
        }
        this.addBArgument(this.alignCorners);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("alignCorners", this.alignCorners);
        ret.put("height", this.height);
        ret.put("width", this.width);
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && (inputDataTypes.size() == 1 || inputDataTypes.size() == 2), "Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(DataType.FLOAT);
    }

    public ResizeArea() {
    }
}

