/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class MaxPoolWithArgmax
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(MaxPoolWithArgmax.class);
    protected Pooling2DConfig config;
    protected DataType outputType;

    public MaxPoolWithArgmax() {
    }

    public MaxPoolWithArgmax(SameDiff sameDiff, SDVariable input, Pooling2DConfig config) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        config.setType(Pooling2D.Pooling2DType.MAX);
        this.config = config;
        this.addArgs();
    }

    public MaxPoolWithArgmax(@NonNull INDArray input, @NonNull Pooling2DConfig config) {
        this(input, null, null, config);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public MaxPoolWithArgmax(@NonNull INDArray input, INDArray output, INDArray outArgMax, @NonNull Pooling2DConfig config) {
        super(null, new INDArray[]{input}, MaxPoolWithArgmax.wrapFilterNull(output, outArgMax));
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        config.setType(Pooling2D.Pooling2DType.MAX);
        this.config = config;
        this.addArgs();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = Pooling2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).isSameMode((Long)this.iArguments.get(8) == 1L).extra(((Long)this.iArguments.get(9)).longValue()).isNHWC((Long)this.iArguments.get(10) == 1L).type(Pooling2D.Pooling2DType.MAX).build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKH(), this.config.getKW(), this.config.getSH(), this.config.getSW(), this.config.getPH(), this.config.getPW(), this.config.getDH(), this.config.getDW(), ArrayUtil.fromBoolean(this.config.isSameMode()), (int)this.config.getExtra(), ArrayUtil.fromBoolean(this.config.isNHWC()));
    }

    public String getPoolingPrefix() {
        return "max";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Pooling2DDerivative pooling2DDerivative = Pooling2DDerivative.derivativeBuilder().inputs(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).config(this.config).build();
        ret.addAll(Arrays.asList(pooling2DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        Pooling2DConfig pooling2DConfig;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        AttrValue aKernels = nodeDef.getAttrOrThrow("ksize");
        List<Long> tfKernels = aKernels.getList().getIList();
        int sH = 0;
        int sW = 0;
        int pH = 0;
        int pW = 0;
        int kH = 0;
        int kW = 0;
        AttrValue aPadding = nodeDef.getAttrOrThrow("padding");
        List<Long> padding = aPadding.getList().getIList();
        String paddingMode = aPadding.getS().toStringUtf8().replaceAll("\"", "");
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        String data_format = "nhwc";
        if (nodeDef.containsAttr("data_format")) {
            AttrValue attr = nodeDef.getAttrOrThrow("data_format");
            data_format = attr.getS().toStringUtf8().toLowerCase();
        }
        if (data_format.equalsIgnoreCase("nhwc")) {
            sH = tfStrides.get(1).intValue();
            sW = tfStrides.get(2).intValue();
            kH = tfKernels.get(1).intValue();
            kW = tfKernels.get(2).intValue();
            pH = padding.size() > 0 ? padding.get(1).intValue() : 0;
            pW = padding.size() > 0 ? padding.get(2).intValue() : 0;
        } else {
            sH = tfStrides.get(2).intValue();
            sW = tfStrides.get(3).intValue();
            kH = tfKernels.get(2).intValue();
            kW = tfKernels.get(3).intValue();
            pH = padding.size() > 0 ? padding.get(2).intValue() : 0;
            pW = padding.size() > 0 ? padding.get(3).intValue() : 0;
        }
        this.config = pooling2DConfig = Pooling2DConfig.builder().sH(sH).sW(sW).type(Pooling2D.Pooling2DType.MAX).isSameMode(isSameMode).kH(kH).kW(kW).pH(pH).pW(pW).isNHWC(data_format.equalsIgnoreCase("nhwc")).extra(1.0).build();
        this.addArgs();
        this.outputType = attributesForNode.containsKey("argmax") ? TFGraphMapper.convertType(attributesForNode.get("argmax").getType()) : DataType.LONG;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"sW", "sH"}).build();
        PropertyMapping paddingMapping = PropertyMapping.builder().onnxAttrName("padding").tfAttrName("padding").propertyNames(new String[]{"pH", "pW"}).build();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kH", "kW"}).tfInputPosition(1).onnxAttrName("ksize").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dW", "dH"}).tfAttrName("rates").build();
        PropertyMapping dataFormatMapping = PropertyMapping.builder().propertyNames(new String[]{"isNHWC"}).tfAttrName("data_format").build();
        map.put("sW", strideMapping);
        map.put("sH", strideMapping);
        map.put("kH", kernelMapping);
        map.put("kW", kernelMapping);
        map.put("dW", dilationMapping);
        map.put("dH", dilationMapping);
        map.put("pH", paddingMapping);
        map.put("pW", paddingMapping);
        map.put("isNHWC", dataFormatMapping);
        ret.put(this.onnxName(), map);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public String opName() {
        return "max_pool_with_argmax";
    }

    @Override
    public String onnxName() {
        return "MaxPoolWithArgmax";
    }

    @Override
    public String tensorflowName() {
        return "MaxPoolWithArgmax";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 1, "Expected 1 input data type for %s, got %s", this.getClass(), inputDataTypes);
        ArrayList<DataType> result = new ArrayList<DataType>();
        result.add(inputDataTypes.get(0));
        result.add(this.outputType == null ? DataType.INT : this.outputType);
        return result;
    }

    public static MaxPoolWithArgmaxBuilder sameDiffBuilder() {
        return new MaxPoolWithArgmaxBuilder();
    }

    public Pooling2DConfig getConfig() {
        return this.config;
    }

    public DataType getOutputType() {
        return this.outputType;
    }

    public static class MaxPoolWithArgmaxBuilder {
        private SameDiff sameDiff;
        private SDVariable input;
        private Pooling2DConfig config;

        MaxPoolWithArgmaxBuilder() {
        }

        public MaxPoolWithArgmaxBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public MaxPoolWithArgmaxBuilder input(SDVariable input) {
            this.input = input;
            return this;
        }

        public MaxPoolWithArgmaxBuilder config(Pooling2DConfig config) {
            this.config = config;
            return this;
        }

        public MaxPoolWithArgmax build() {
            return new MaxPoolWithArgmax(this.sameDiff, this.input, this.config);
        }

        public String toString() {
            return "MaxPoolWithArgmax.MaxPoolWithArgmaxBuilder(sameDiff=" + this.sameDiff + ", input=" + this.input + ", config=" + this.config + ")";
        }
    }
}

