/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;

public class ReductionShape
extends DynamicCustomOp {
    private boolean keepDims;

    public ReductionShape() {
    }

    public ReductionShape(@NonNull SameDiff sameDiff, @NonNull SDVariable shape, @NonNull SDVariable axis, boolean keepDims) {
        super(sameDiff, new SDVariable[]{shape, axis});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (axis == null) {
            throw new NullPointerException("axis is marked non-null but is null");
        }
        this.keepDims = keepDims;
        this.addBArgument(keepDims);
    }

    @Override
    public String opName() {
        return "evaluate_reduction_shape";
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Arrays.asList(this.sameDiff.zerosLike(this.arg(0)), this.sameDiff.zerosLike(this.arg(1)));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes.size() == 2, "Expected list with exactly 2 datatypes for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState(dataTypes.get(0).isIntType(), "Input 0 (shape) must be integer datatype, is %s", (Object)dataTypes.get(0));
        Preconditions.checkState(dataTypes.get(0).isIntType(), "Input 1 (axis) must be an integer datatype, is %s", (Object)dataTypes.get(1));
        return Collections.singletonList(dataTypes.get(0));
    }
}

