/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape.bp;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatBp
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(ConcatBp.class);
    private int concatDimension;
    private boolean dynamicAxis;

    public ConcatBp() {
    }

    public ConcatBp(@NonNull SameDiff sameDiff, int concatDimension, SDVariable ... inputsAndGrad) {
        super(null, sameDiff, inputsAndGrad);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (inputsAndGrad == null) {
            throw new NullPointerException("inputsAndGrad is marked non-null but is null");
        }
        this.addIArgument(concatDimension);
        this.concatDimension = concatDimension;
    }

    public ConcatBp(@NonNull SameDiff sameDiff, SDVariable ... inputsGradAxis) {
        super(null, sameDiff, inputsGradAxis);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (inputsGradAxis == null) {
            throw new NullPointerException("inputsGradAxis is marked non-null but is null");
        }
        Preconditions.checkState(inputsGradAxis[inputsGradAxis.length - 1].dataType().isIntType(), "When using this constructor, the last input must be an integer array (for the axis)");
        this.addBArgument(true);
        this.dynamicAxis = true;
    }

    @Override
    public String opName() {
        return "concat_bp";
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public int getNumOutputs() {
        return this.args().length - 1 - (this.dynamicAxis ? 1 : 0);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        SDVariable[] args = this.args();
        Preconditions.checkState(dataTypes.size() == args.length, "Expected list with exactly %s datatypes (original inputs + gradient), got %s", (Object)args.length, dataTypes);
        int n = this.getNumOutputs();
        ArrayList<DataType> out = new ArrayList<DataType>(n);
        for (int i = 0; i < n; ++i) {
            out.add(this.arg(i).dataType());
        }
        return out;
    }
}

