/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape.tensorops;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.PartitionMode;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;

public class EmbeddingLookup
extends DynamicCustomOp {
    public EmbeddingLookup(@NonNull SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable indices, PartitionMode partitionMode) {
        super("embedding_lookup", sameDiff, new SDVariable[]{in, indices});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (indices == null) {
            throw new NullPointerException("indices is marked non-null but is null");
        }
        this.addIArgument(partitionMode.ordinal());
    }

    public EmbeddingLookup(@NonNull INDArray in, @NonNull INDArray indices, PartitionMode partitionMode, INDArray output) {
        super("embedding_lookup", new INDArray[]{in, indices}, EmbeddingLookup.wrapOrNull(output));
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (indices == null) {
            throw new NullPointerException("indices is marked non-null but is null");
        }
        this.addIArgument(partitionMode.ordinal());
    }

    public EmbeddingLookup(@NonNull INDArray in, INDArray output, PartitionMode partitionMode, int ... indices) {
        super("embedding_lookup", new INDArray[]{in, Nd4j.createFromArray(indices)}, EmbeddingLookup.wrapOrNull(output));
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (indices == null) {
            throw new NullPointerException("indices is marked non-null but is null");
        }
        this.addIArgument(partitionMode.ordinal());
    }

    @Override
    public String opName() {
        return "embedding_lookup";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkArgument(dataTypes != null && dataTypes.size() == 2, "Expected exactly 2 input datatypes, got %s", dataTypes);
        Preconditions.checkArgument(dataTypes.get(0).isFPType(), "Input datatype must be floating point, got %s", dataTypes);
        Preconditions.checkArgument(dataTypes.get(1).isIntType(), "Input datatype must be integer point, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    public EmbeddingLookup() {
    }
}

