/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDIndex;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.PadMode;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Pad
extends DynamicCustomOp {
    private Mode mode;
    private double constant;

    public Pad() {
    }

    private static Mode adaptMode(PadMode mode) {
        Mode legacyMode = Mode.CONSTANT;
        if (mode == PadMode.CONSTANT) {
            legacyMode = Mode.CONSTANT;
        } else if (mode == PadMode.REFLECT) {
            legacyMode = Mode.REFLECT;
        } else if (mode == PadMode.SYMMETRIC) {
            legacyMode = Mode.SYMMETRIC;
        }
        return legacyMode;
    }

    public Pad(SameDiff sd, SDVariable in, SDVariable padding, PadMode mode, double padValue) {
        this(sd, in, padding, Pad.adaptMode(mode), padValue);
    }

    public Pad(SameDiff sd, SDVariable in, SDVariable padding, Mode mode, double padValue) {
        super(sd, new SDVariable[]{in, padding}, false);
        Preconditions.checkState(padding.dataType().isIntType(), "Padding array must be an integer datatype, got %s", (Object)padding.dataType());
        this.mode = mode;
        this.addIArgument(mode.ordinal());
        this.addTArgument(padValue);
    }

    public Pad(SameDiff sd, SDVariable in, SDVariable padding, double padValue) {
        this(sd, in, padding, Mode.CONSTANT, padValue);
    }

    public Pad(@NonNull INDArray in, @NonNull INDArray padding, double padValue) {
        this(in, padding, null, Mode.CONSTANT, padValue);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (padding == null) {
            throw new NullPointerException("padding is marked non-null but is null");
        }
    }

    public Pad(@NonNull INDArray in, @NonNull INDArray padding, @NonNull PadMode mode, double padValue) {
        this(in, padding, null, Pad.adaptMode(mode), padValue);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (padding == null) {
            throw new NullPointerException("padding is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
    }

    public Pad(@NonNull INDArray in, @NonNull INDArray padding, INDArray out, @NonNull Mode mode, double padValue) {
        INDArray[] iNDArrayArray;
        INDArray[] iNDArrayArray2 = new INDArray[]{in, padding};
        if (out == null) {
            iNDArrayArray = null;
        } else {
            INDArray[] iNDArrayArray3 = new INDArray[1];
            iNDArrayArray = iNDArrayArray3;
            iNDArrayArray3[0] = out;
        }
        super(null, iNDArrayArray2, iNDArrayArray);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (padding == null) {
            throw new NullPointerException("padding is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        Preconditions.checkState(padding.dataType().isIntType(), "Padding array must be an integer datatype, got %s", (Object)padding.dataType());
        this.mode = mode;
        this.addIArgument(mode.ordinal());
        this.addTArgument(padValue);
    }

    public Pad(@NonNull INDArray in, @NonNull INDArray padding, INDArray out, @NonNull PadMode mode, double padValue) {
        this(in, padding, out, Pad.adaptMode(mode), padValue);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (padding == null) {
            throw new NullPointerException("padding is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
    }

    @Override
    public String opName() {
        return "pad";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Pad", "PadV2"};
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.mode = Mode.CONSTANT;
        this.addIArgument(this.mode.ordinal());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable shape = this.arg().shape();
        SDVariable begin = this.arg(1).get(SDIndex.all(), SDIndex.point(0L));
        SDVariable gradAtIn = this.sameDiff.slice(i_v.get(0), begin, shape);
        SDVariable zeros = this.sameDiff.zerosLike(this.arg(1));
        return Arrays.asList(gradAtIn, zeros);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() >= 1 && inputDataTypes.size() <= 3, "Expected 1-3 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static enum Mode {
        CONSTANT,
        REFLECT,
        SYMMETRIC;

    }
}

