/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class MultiHeadDotProductAttentionBp
extends DynamicCustomOp {
    private boolean scaled;

    public MultiHeadDotProductAttentionBp(SameDiff sameDiff, SDVariable queries, SDVariable keys, SDVariable values, SDVariable Wq, SDVariable Wk, SDVariable Wv, SDVariable Wo, SDVariable eps, SDVariable mask, boolean scaled) {
        SDVariable[] sDVariableArray;
        if (mask == null) {
            SDVariable[] sDVariableArray2 = new SDVariable[8];
            sDVariableArray2[0] = queries;
            sDVariableArray2[1] = keys;
            sDVariableArray2[2] = values;
            sDVariableArray2[3] = Wq;
            sDVariableArray2[4] = Wk;
            sDVariableArray2[5] = Wv;
            sDVariableArray2[6] = Wo;
            sDVariableArray = sDVariableArray2;
            sDVariableArray2[7] = eps;
        } else {
            SDVariable[] sDVariableArray3 = new SDVariable[9];
            sDVariableArray3[0] = queries;
            sDVariableArray3[1] = keys;
            sDVariableArray3[2] = values;
            sDVariableArray3[3] = Wq;
            sDVariableArray3[4] = Wk;
            sDVariableArray3[5] = Wv;
            sDVariableArray3[6] = Wo;
            sDVariableArray3[7] = eps;
            sDVariableArray = sDVariableArray3;
            sDVariableArray3[8] = mask;
        }
        super(null, sameDiff, sDVariableArray, false);
        this.scaled = scaled;
        this.addIArgument(scaled ? 1 : 0);
    }

    @Override
    public String opName() {
        return "multi_head_dot_product_attention_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        throw new UnsupportedOperationException("Differentiation of " + this.getClass().getName() + " not supported");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && (dataTypes.size() == 8 || dataTypes.size() == 9), "Expected 8 or 9 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (int i = 0; i < dataTypes.size(); ++i) {
            Preconditions.checkState(dataTypes.get(i).isFPType(), "Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            if (i <= 0) continue;
            Preconditions.checkState(first == dataTypes.get(i), "All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        return Arrays.asList(first, first, first, first, first, first, first);
    }

    public MultiHeadDotProductAttentionBp() {
    }
}

