/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.ThresholdReluBp;

public class ThresholdRelu
extends DynamicCustomOp {
    private double cutoff = 0.0;

    public ThresholdRelu() {
    }

    public ThresholdRelu(SameDiff sd, SDVariable input, boolean inPlace, double cutoff) {
        super(sd, new SDVariable[]{input}, inPlace);
        this.cutoff = cutoff;
        this.addTArgument(cutoff);
    }

    public ThresholdRelu(SameDiff sd, SDVariable input, double cutoff) {
        super(sd, new SDVariable[]{input});
        this.cutoff = cutoff;
        this.addTArgument(cutoff);
    }

    public ThresholdRelu(@NonNull INDArray input, INDArray output, double cutoff) {
        super(new INDArray[]{input}, ThresholdRelu.wrapOrNull(output));
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.cutoff = cutoff;
        this.addTArgument(cutoff);
    }

    @Override
    public String opName() {
        return "thresholdedrelu";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkArgument(dataTypes != null && dataTypes.size() == 1, "Expected exactly 1 input datatypes, got %s", dataTypes);
        Preconditions.checkArgument(dataTypes.get(0).isFPType(), "Input datatype must be floating point, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return new ThresholdReluBp(this.sameDiff, this.arg(), f1.get(0), this.cutoff).outputs();
    }

    public double getCutoff() {
        return this.cutoff;
    }
}

