/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.compression;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lombok.NonNull;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedDataBuffer
extends BaseDataBuffer {
    protected CompressionDescriptor compressionDescriptor;
    private static Logger logger = LoggerFactory.getLogger(CompressedDataBuffer.class);

    public CompressedDataBuffer(Pointer pointer, @NonNull CompressionDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked non-null but is null");
        }
        this.compressionDescriptor = descriptor;
        this.pointer = pointer;
        this.length = descriptor.getNumberOfElements();
        this.elementSize = (byte)descriptor.getOriginalElementSize();
        this.initTypeAndSize();
    }

    @Override
    protected void initTypeAndSize() {
        this.type = DataType.COMPRESSED;
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.allocationMode.name());
        out.writeLong(this.compressionDescriptor.getCompressedLength());
        out.writeUTF(DataType.COMPRESSED.name());
        out.writeUTF(this.compressionDescriptor.getCompressionAlgorithm());
        out.writeLong(this.compressionDescriptor.getCompressedLength());
        out.writeLong(this.compressionDescriptor.getOriginalLength());
        out.writeLong(this.compressionDescriptor.getNumberOfElements());
        out.writeInt(this.compressionDescriptor.getOriginalDataType().ordinal());
        int x = 0;
        while ((long)x < this.pointer.capacity() * (long)this.pointer.sizeof()) {
            byte b = this.pointer.asByteBuffer().get(x);
            out.writeByte(b);
            ++x;
        }
    }

    @Override
    protected void setIndexer(Indexer indexer) {
    }

    @Override
    public Pointer addressPointer() {
        return this.pointer;
    }

    public static DataBuffer readUnknown(DataInputStream s, DataBuffer.AllocationMode allocMode, long length, DataType type) {
        if (type != DataType.COMPRESSED) {
            DataBuffer buffer = Nd4j.createBuffer(type, length, false);
            buffer.read(s, allocMode, length, type);
            return buffer;
        }
        try {
            String compressionAlgorithm = s.readUTF();
            long compressedLength = s.readLong();
            long originalLength = s.readLong();
            long numberOfElements = s.readLong();
            DataType originalType = DataType.values()[s.readInt()];
            byte[] temp = new byte[(int)compressedLength];
            int i = 0;
            while ((long)i < compressedLength) {
                temp[i] = s.readByte();
                ++i;
            }
            BytePointer pointer = new BytePointer(temp);
            CompressionDescriptor descriptor = new CompressionDescriptor();
            descriptor.setCompressedLength(compressedLength);
            descriptor.setCompressionAlgorithm(compressionAlgorithm);
            descriptor.setOriginalLength(originalLength);
            descriptor.setNumberOfElements(numberOfElements);
            descriptor.setOriginalDataType(originalType);
            return new CompressedDataBuffer(pointer, descriptor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataBuffer dup() {
        BytePointer nPtr = new BytePointer(this.compressionDescriptor.getCompressedLength());
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        Pointer.memcpy(nPtr, this.pointer, this.compressionDescriptor.getCompressedLength());
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, this.compressionDescriptor.getCompressedLength(), MemcpyDirection.HOST_TO_HOST);
        CompressionDescriptor nDesc = this.compressionDescriptor.clone();
        CompressedDataBuffer nBuf = new CompressedDataBuffer(nPtr, nDesc);
        return nBuf;
    }

    @Override
    public long length() {
        return this.compressionDescriptor.getNumberOfElements();
    }

    @Override
    protected DataBuffer create(long length) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    @Override
    public DataBuffer create(double[] data) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    @Override
    public DataBuffer create(float[] data) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    @Override
    public DataBuffer create(int[] data) {
        throw new UnsupportedOperationException("This method isn't supported by CompressedDataBuffer");
    }

    @Override
    public void pointerIndexerByCurrentType(DataType currentType) {
        throw new UnsupportedOperationException("This method isn't supported by CompressedDataBuffer");
    }

    @Override
    public DataBuffer reallocate(long length) {
        throw new UnsupportedOperationException("This method isn't supported by CompressedDataBuffer");
    }

    @Override
    public void syncToPrimary() {
    }

    @Override
    public void syncToSpecial() {
    }

    @Override
    protected double getDoubleUnsynced(long index) {
        return super.getDouble(index);
    }

    @Override
    protected float getFloatUnsynced(long index) {
        return super.getFloat(index);
    }

    @Override
    protected long getLongUnsynced(long index) {
        return super.getLong(index);
    }

    @Override
    protected int getIntUnsynced(long index) {
        return super.getInt(index);
    }

    public CompressionDescriptor getCompressionDescriptor() {
        return this.compressionDescriptor;
    }

    public void setCompressionDescriptor(CompressionDescriptor compressionDescriptor) {
        this.compressionDescriptor = compressionDescriptor;
    }
}

