/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dimensionalityreduction;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.eigen.Eigen;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;

public class PCA {
    private INDArray covarianceMatrix;
    private INDArray mean;
    private INDArray eigenvectors;
    private INDArray eigenvalues;

    private PCA() {
    }

    public PCA(INDArray dataset) {
        INDArray[] covmean = PCA.covarianceMatrix(dataset);
        this.covarianceMatrix = covmean[0];
        this.mean = covmean[1];
        INDArray[] pce = PCA.principalComponents(covmean[0]);
        this.eigenvectors = pce[0];
        this.eigenvalues = pce[1];
    }

    public INDArray reducedBasis(double variance) {
        INDArray vars = Transforms.pow(this.eigenvalues, -0.5, true);
        double res = vars.sumNumber().doubleValue();
        double total = 0.0;
        int ndims = 0;
        for (int i = 0; i < vars.columns(); ++i) {
            ++ndims;
            if ((total += vars.getDouble((long)i)) / res > variance) break;
        }
        INDArray result = Nd4j.create(this.eigenvectors.rows(), ndims);
        for (int i = 0; i < ndims; ++i) {
            result.putColumn(i, this.eigenvectors.getColumn(i));
        }
        return result;
    }

    public INDArray convertToComponents(INDArray data) {
        INDArray dx = data.subRowVector(this.mean);
        return Nd4j.tensorMmul(this.eigenvectors.transpose(), dx, new int[][]{{1}, {1}}).transposei();
    }

    public INDArray convertBackToFeatures(INDArray data) {
        return Nd4j.tensorMmul(this.eigenvectors, data, new int[][]{{1}, {1}}).transposei().addiRowVector(this.mean);
    }

    public double estimateVariance(INDArray data, int ndims) {
        INDArray dx = data.sub(this.mean);
        INDArray v = this.eigenvectors.transpose().mmul(dx.reshape((long)dx.columns(), 1L));
        INDArray t2 = Transforms.pow(v, 2);
        double fraction = t2.get(NDArrayIndex.interval(0, ndims)).sumNumber().doubleValue();
        double total = t2.sumNumber().doubleValue();
        return fraction / total;
    }

    public INDArray generateGaussianSamples(long count) {
        INDArray samples = Nd4j.randn(count, this.eigenvalues.columns());
        INDArray factors = Transforms.pow(this.eigenvalues, -0.5, true);
        samples.muliRowVector(factors);
        return Nd4j.tensorMmul(this.eigenvectors, samples, new int[][]{{1}, {1}}).transposei().addiRowVector(this.mean);
    }

    public static INDArray pca(INDArray A, int nDims, boolean normalize) {
        INDArray factor = PCA.pca_factor(A, nDims, normalize);
        return A.mmul(factor);
    }

    public static INDArray pca_factor(INDArray A, int nDims, boolean normalize) {
        if (normalize) {
            INDArray mean = A.mean(0);
            A.subiRowVector(mean);
        }
        long m = A.rows();
        long n = A.columns();
        INDArray s = Nd4j.create(A.dataType(), m < n ? m : n);
        INDArray VT = Nd4j.create(A.dataType(), new long[]{n, n}, 'f');
        Nd4j.getBlasWrapper().lapack().gesvd(A, s, null, VT);
        INDArray V = VT.transpose();
        INDArray factor = Nd4j.create(A.dataType(), new long[]{n, nDims}, 'f');
        for (int i = 0; i < nDims; ++i) {
            factor.putColumn(i, V.getColumn(i));
        }
        return factor;
    }

    public static INDArray pca(INDArray A, double variance, boolean normalize) {
        INDArray factor = PCA.pca_factor(A, variance, normalize);
        return A.mmul(factor);
    }

    public static INDArray pca_factor(INDArray A, double variance, boolean normalize) {
        if (normalize) {
            INDArray mean = A.mean(0);
            A.subiRowVector(mean);
        }
        long m = A.rows();
        long n = A.columns();
        INDArray s = Nd4j.create(A.dataType(), m < n ? m : n);
        INDArray VT = Nd4j.create(A.dataType(), new long[]{n, n}, 'f');
        Nd4j.getBlasWrapper().lapack().gesvd(A, s, null, VT);
        int i = 0;
        while ((long)i < s.length()) {
            s.putScalar((long)i, Math.sqrt(s.getDouble((long)i)) / (double)(m - 1L));
            ++i;
        }
        double totalEigSum = s.sumNumber().doubleValue() * variance;
        int k = -1;
        double runningTotal = 0.0;
        int i2 = 0;
        while ((long)i2 < s.length()) {
            if ((runningTotal += s.getDouble((long)i2)) >= totalEigSum) {
                k = i2 + 1;
                break;
            }
            ++i2;
        }
        if (k == -1) {
            throw new RuntimeException("No reduction possible for reqd. variance - use smaller variance");
        }
        INDArray V = VT.transpose();
        INDArray factor = Nd4j.createUninitialized(A.dataType(), new long[]{n, k}, 'f');
        for (int i3 = 0; i3 < k; ++i3) {
            factor.putColumn(i3, V.getColumn(i3));
        }
        return factor;
    }

    public static INDArray pca2(INDArray in, double variance) {
        INDArray[] covmean = PCA.covarianceMatrix(in);
        INDArray[] pce = PCA.principalComponents(covmean[0]);
        INDArray vars = Transforms.pow(pce[1], -0.5, true);
        double res = vars.sumNumber().doubleValue();
        double total = 0.0;
        int ndims = 0;
        for (int i = 0; i < vars.columns(); ++i) {
            ++ndims;
            if ((total += vars.getDouble((long)i)) / res > variance) break;
        }
        INDArray result = Nd4j.create(in.columns(), ndims);
        for (int i = 0; i < ndims; ++i) {
            result.putColumn(i, pce[0].getColumn(i));
        }
        return result;
    }

    public static INDArray[] covarianceMatrix(INDArray in) {
        long dlength = in.rows();
        long vlength = in.columns();
        INDArray product = Nd4j.create(vlength, vlength);
        INDArray sum = in.sum(0).divi(dlength);
        int i = 0;
        while ((long)i < dlength) {
            INDArray dx1 = in.getRow(i).sub(sum);
            product.addi(dx1.reshape(vlength, 1L).mmul(dx1.reshape(1L, vlength)));
            ++i;
        }
        product.divi(dlength);
        return new INDArray[]{product, sum};
    }

    public static INDArray[] principalComponents(INDArray cov) {
        INDArray[] result;
        Preconditions.checkArgument(cov.isMatrix() && cov.isSquare(), "Convariance matrix must be a square matrix: has shape %s", (Object)cov.shape());
        result = new INDArray[]{Nd4j.eye(cov.rows()), Eigen.symmetricGeneralizedEigenvalues(result[0], cov, true)};
        return result;
    }

    public INDArray getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public INDArray getMean() {
        return this.mean;
    }

    public INDArray getEigenvectors() {
        return this.eigenvectors;
    }

    public INDArray getEigenvalues() {
        return this.eigenvalues;
    }
}

