/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.util.Arrays;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAMax;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAMin;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMax;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMin;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.bool.BroadcastEqualTo;
import org.nd4j.linalg.api.ops.impl.broadcast.bool.BroadcastGreaterThan;
import org.nd4j.linalg.api.ops.impl.broadcast.bool.BroadcastGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.broadcast.bool.BroadcastLessThan;
import org.nd4j.linalg.api.ops.impl.broadcast.bool.BroadcastLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.broadcast.bool.BroadcastNotEqual;
import org.nd4j.linalg.api.ops.impl.transforms.custom.EqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.custom.GreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.GreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LessThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Max;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Min;
import org.nd4j.linalg.api.ops.impl.transforms.custom.NotEqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.CopyOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.DivOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.MulOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.RDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.SubOp;
import org.nd4j.linalg.api.ops.impl.transforms.same.AMax;
import org.nd4j.linalg.api.ops.impl.transforms.same.AMin;
import org.nd4j.linalg.factory.Nd4j;

public class Broadcast {
    private Broadcast() {
    }

    public static INDArray add(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new AddOp(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastAddOp(x, y, z, dimensions));
    }

    public static INDArray copy(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new CopyOp(x, y, z));
        }
        return Nd4j.getExecutioner().exec(new BroadcastCopyOp(x, y, z, dimensions));
    }

    public static INDArray div(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new DivOp(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastDivOp(x, y, z, dimensions));
    }

    public static INDArray eq(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new EqualTo(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastEqualTo(x, y, z, dimensions));
    }

    public static INDArray gt(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new GreaterThan(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastGreaterThan(x, y, z, dimensions));
    }

    public static INDArray gte(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new GreaterThanOrEqual(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastGreaterThanOrEqual(x, y, z, dimensions));
    }

    public static INDArray lt(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new LessThan(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastLessThan(x, y, z, dimensions));
    }

    public static INDArray lte(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new LessThanOrEqual(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastLessThanOrEqual(x, y, z, dimensions));
    }

    public static INDArray mul(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new MulOp(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastMulOp(x, y, z, dimensions));
    }

    public static INDArray neq(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new NotEqualTo(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastNotEqual(x, y, z, dimensions));
    }

    public static INDArray rdiv(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new RDivOp(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastRDivOp(x, y, z, dimensions));
    }

    public static INDArray rsub(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new SubOp(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastRSubOp(x, y, z, dimensions));
    }

    public static INDArray sub(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new SubOp(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastSubOp(x, y, z, dimensions));
    }

    public static INDArray max(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new Max(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastMax(x, y, z, dimensions));
    }

    public static INDArray min(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new Min(x, y, z))[0];
        }
        return Nd4j.getExecutioner().exec(new BroadcastMin(x, y, z, dimensions));
    }

    public static INDArray amax(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new AMax(x, y, z));
        }
        return Nd4j.getExecutioner().exec(new BroadcastAMax(x, y, z, dimensions));
    }

    public static INDArray amin(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().exec(new AMin(x, y, z));
        }
        return Nd4j.getExecutioner().exec(new BroadcastAMin(x, y, z, dimensions));
    }

    public static void validateShapesNoDimCase(INDArray x, INDArray y, INDArray z) {
        Preconditions.checkArgument(x.equalShapes(y), "When no dimensions are provided, X and Y shapes must be equal (x shape: %s, y shape: %s)", (Object)x.shape(), (Object)y.shape());
        Preconditions.checkArgument(x.equalShapes(z), "When no dimensions are provided, X and Z (result) shapes must be equal (x shape: %s, z shape: %s)", (Object)x.shape(), (Object)z.shape());
    }

    public static void validateBroadcastDims(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        Preconditions.checkArgument(x == z || x.equalShapes(z), "X and Z arrays must be equal shape. X shape: %s, Z shape: %s", (Object)x.shape(), (Object)z.shape());
        long[] sx = x.shape();
        long[] sy = y.shape();
        if (dimensions.length == 1 && sy.length == 2 && (sy[0] == 1L || sy[1] == 1L)) {
            int d2;
            int n = d2 = dimensions[0] < 0 ? dimensions[0] + sx.length : dimensions[0];
            if (sy[0] == 1L) {
                Preconditions.checkState(sx[d2] == sy[1], "Shapes do not match: dimensions[0] - x[%s] must match y[%s], x shape %s, y shape %s, dimensions %s", (Object)dimensions[0], (Object)1, (Object)sx, (Object)sy, (Object)dimensions);
            } else {
                Preconditions.checkState(sx[d2] == sy[0], "Shapes do not match: dimensions[0] - x[%s] must match y[%s], x shape %s, y shape %s, dimensions %s", (Object)dimensions[0], (Object)0, (Object)sx, (Object)sy, (Object)dimensions);
            }
        } else if (sx.length == sy.length) {
            for (int d : dimensions) {
                int d2 = d < 0 ? d + sx.length : d;
                Preconditions.checkState(sx[d2] == sy[d2], "Dimensions mismatch on dimension %s: x shape %s, y shape %s", (Object)d, (Object)sx, (Object)sy);
            }
        } else if (dimensions.length == sy.length) {
            for (int i = 0; i < dimensions.length; ++i) {
                int d2 = dimensions[i] < 0 ? dimensions[i] + sx.length : dimensions[i];
                Preconditions.checkState(sx[d2] == sy[i], "Shapes do not match: dimensions[%s] - x[%s] must match y[%s], x shape %s, y shape %s, dimensions %s", (Object)i, (Object)d2, (Object)i, (Object)sx, (Object)sy, (Object)dimensions);
            }
        } else {
            throw new IllegalStateException("Invalid broadcast dimensions: x shape " + Arrays.toString(sx) + ", y shape " + Arrays.toString(sy) + ", dimensions " + Arrays.toString(dimensions));
        }
    }
}

