/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory.ops;

import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.ImageResizeMethod;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.custom.AdjustContrast;
import org.nd4j.linalg.api.ops.custom.AdjustHue;
import org.nd4j.linalg.api.ops.custom.AdjustSaturation;
import org.nd4j.linalg.api.ops.custom.HsvToRgb;
import org.nd4j.linalg.api.ops.custom.RandomCrop;
import org.nd4j.linalg.api.ops.custom.RgbToHsv;
import org.nd4j.linalg.api.ops.custom.RgbToYiq;
import org.nd4j.linalg.api.ops.custom.RgbToYuv;
import org.nd4j.linalg.api.ops.custom.YiqToRgb;
import org.nd4j.linalg.api.ops.custom.YuvToRgb;
import org.nd4j.linalg.api.ops.impl.image.CropAndResize;
import org.nd4j.linalg.api.ops.impl.image.ExtractImagePatches;
import org.nd4j.linalg.api.ops.impl.image.ImageResize;
import org.nd4j.linalg.api.ops.impl.image.NonMaxSuppression;
import org.nd4j.linalg.factory.NDValidation;
import org.nd4j.linalg.factory.Nd4j;

public class NDImage {
    public INDArray cropAndResize(INDArray image, INDArray cropBoxes, INDArray boxIndices, INDArray cropOutSize, double extrapolationValue) {
        NDValidation.validateNumerical("CropAndResize", "image", image);
        NDValidation.validateNumerical("CropAndResize", "cropBoxes", cropBoxes);
        NDValidation.validateNumerical("CropAndResize", "boxIndices", boxIndices);
        NDValidation.validateInteger("CropAndResize", "cropOutSize", cropOutSize);
        return Nd4j.exec(new CropAndResize(image, cropBoxes, boxIndices, cropOutSize, extrapolationValue))[0];
    }

    public INDArray cropAndResize(INDArray image, INDArray cropBoxes, INDArray boxIndices, INDArray cropOutSize) {
        NDValidation.validateNumerical("CropAndResize", "image", image);
        NDValidation.validateNumerical("CropAndResize", "cropBoxes", cropBoxes);
        NDValidation.validateNumerical("CropAndResize", "boxIndices", boxIndices);
        NDValidation.validateInteger("CropAndResize", "cropOutSize", cropOutSize);
        return Nd4j.exec(new CropAndResize(image, cropBoxes, boxIndices, cropOutSize, 0.0))[0];
    }

    public INDArray adjustContrast(INDArray in, double factor) {
        NDValidation.validateNumerical("adjustContrast", "in", in);
        return Nd4j.exec(new AdjustContrast(in, factor))[0];
    }

    public INDArray adjustHue(INDArray in, double delta) {
        NDValidation.validateNumerical("adjustHue", "in", in);
        return Nd4j.exec(new AdjustHue(in, delta))[0];
    }

    public INDArray adjustSaturation(INDArray in, double factor) {
        NDValidation.validateNumerical("adjustSaturation", "in", in);
        return Nd4j.exec(new AdjustSaturation(in, factor))[0];
    }

    public INDArray extractImagePatches(INDArray image, int[] kSizes, int[] strides, int[] rates, boolean sameMode) {
        NDValidation.validateNumerical("extractImagePatches", "image", image);
        Preconditions.checkArgument(kSizes.length == 2, "kSizes has incorrect size/length. Expected: kSizes.length == 2, got %s", kSizes.length);
        Preconditions.checkArgument(strides.length == 2, "strides has incorrect size/length. Expected: strides.length == 2, got %s", strides.length);
        Preconditions.checkArgument(rates.length >= 0, "rates has incorrect size/length. Expected: rates.length >= 0, got %s", rates.length);
        return Nd4j.exec(new ExtractImagePatches(image, kSizes, strides, rates, sameMode))[0];
    }

    public INDArray hsvToRgb(INDArray input) {
        NDValidation.validateNumerical("hsvToRgb", "input", input);
        return Nd4j.exec(new HsvToRgb(input))[0];
    }

    public INDArray imageResize(INDArray input, INDArray size, boolean preserveAspectRatio, boolean antialis, ImageResizeMethod ImageResizeMethod2) {
        NDValidation.validateNumerical("imageResize", "input", input);
        NDValidation.validateInteger("imageResize", "size", size);
        return Nd4j.exec(new ImageResize(input, size, preserveAspectRatio, antialis, ImageResizeMethod2))[0];
    }

    public INDArray imageResize(INDArray input, INDArray size, ImageResizeMethod ImageResizeMethod2) {
        NDValidation.validateNumerical("imageResize", "input", input);
        NDValidation.validateInteger("imageResize", "size", size);
        return Nd4j.exec(new ImageResize(input, size, false, false, ImageResizeMethod2))[0];
    }

    public INDArray nonMaxSuppression(INDArray boxes, INDArray scores, int maxOutSize, double iouThreshold, double scoreThreshold) {
        NDValidation.validateNumerical("nonMaxSuppression", "boxes", boxes);
        NDValidation.validateNumerical("nonMaxSuppression", "scores", scores);
        return Nd4j.exec(new NonMaxSuppression(boxes, scores, maxOutSize, iouThreshold, scoreThreshold))[0];
    }

    public INDArray randomCrop(INDArray input, INDArray shape) {
        NDValidation.validateNumerical("randomCrop", "input", input);
        NDValidation.validateInteger("randomCrop", "shape", shape);
        return Nd4j.exec(new RandomCrop(input, shape))[0];
    }

    public INDArray rgbToHsv(INDArray input) {
        NDValidation.validateNumerical("rgbToHsv", "input", input);
        return Nd4j.exec(new RgbToHsv(input))[0];
    }

    public INDArray rgbToYiq(INDArray input) {
        NDValidation.validateNumerical("rgbToYiq", "input", input);
        return Nd4j.exec(new RgbToYiq(input))[0];
    }

    public INDArray rgbToYuv(INDArray input) {
        NDValidation.validateNumerical("rgbToYuv", "input", input);
        return Nd4j.exec(new RgbToYuv(input))[0];
    }

    public INDArray yiqToRgb(INDArray input) {
        NDValidation.validateNumerical("yiqToRgb", "input", input);
        return Nd4j.exec(new YiqToRgb(input))[0];
    }

    public INDArray yuvToRgb(INDArray input) {
        NDValidation.validateNumerical("yuvToRgb", "input", input);
        return Nd4j.exec(new YuvToRgb(input))[0];
    }
}

