/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions.impl;

import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.custom.SoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.same.TimesOneMinus;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossUtil;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.serde.jackson.shaded.NDArrayTextDeSerializer;
import org.nd4j.serde.jackson.shaded.NDArrayTextSerializer;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LossBinaryXENT
implements ILossFunction {
    public static final double DEFAULT_CLIPPING_EPSILON = 1.0E-5;
    @JsonSerialize(using=NDArrayTextSerializer.class)
    @JsonDeserialize(using=NDArrayTextDeSerializer.class)
    private final INDArray weights;
    private double clipEps;

    public LossBinaryXENT() {
        this(null);
    }

    public LossBinaryXENT(INDArray weights) {
        this(1.0E-5, weights);
    }

    public LossBinaryXENT(double clipEps) {
        this(clipEps, null);
    }

    public LossBinaryXENT(@JsonProperty(value="clipEps") double clipEps, @JsonProperty(value="weights") INDArray weights) {
        if (weights != null && !weights.isRowVector()) {
            throw new IllegalArgumentException("Weights array must be a row vector");
        }
        if (clipEps < 0.0 || clipEps > 0.5) {
            throw new IllegalArgumentException("Invalid clipping epsilon value: epsilon should be >= 0 (but near zero).Got: " + clipEps);
        }
        this.clipEps = clipEps;
        this.weights = weights;
    }

    private INDArray scoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr;
        if (!labels.equalShapes(preOutput)) {
            Preconditions.throwEx("Labels and preOutput must have equal shapes: got shapes %s vs %s", labels.shape(), preOutput.shape());
        }
        labels = labels.castTo(preOutput.dataType());
        if (activationFn instanceof ActivationSoftmax) {
            INDArray logsoftmax = Nd4j.exec(new SoftMax(preOutput, preOutput.ulike(), -1))[0];
            Transforms.log(logsoftmax, false);
            scoreArr = logsoftmax.muli(labels);
        } else {
            INDArray output = activationFn.getActivation(preOutput.dup(), true);
            if (this.clipEps > 0.0) {
                DynamicCustomOp op = DynamicCustomOp.builder("clipbyvalue").addInputs(output).callInplace(true).addFloatingPointArguments(this.clipEps, 1.0 - this.clipEps).build();
                Nd4j.getExecutioner().execAndReturn(op);
            }
            scoreArr = Transforms.log(output, true).muli(labels);
            INDArray secondTerm = output.rsubi(1);
            Transforms.log(secondTerm, false);
            secondTerm.muli(labels.rsub(1));
            scoreArr.addi(secondTerm);
        }
        if (this.weights != null) {
            if (this.weights.length() != preOutput.size(1)) {
                throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + preOutput.size(1));
            }
            scoreArr.muliRowVector(this.weights.castTo(scoreArr.dataType()));
        }
        if (mask != null) {
            LossUtil.applyMask(scoreArr, mask);
        }
        return scoreArr;
    }

    @Override
    public double computeScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        double score = -scoreArr.sumNumber().doubleValue();
        if (average) {
            score /= (double)scoreArr.size(0);
        }
        return score;
    }

    @Override
    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(true, 1).muli(-1);
    }

    @Override
    public INDArray computeGradient(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        if (!labels.equalShapes(preOutput)) {
            Preconditions.throwEx("Labels and preOutput must have equal shapes: got shapes %s vs %s", labels.shape(), preOutput.shape());
        }
        labels = labels.castTo(preOutput.dataType());
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        if (this.clipEps > 0.0) {
            DynamicCustomOp op = DynamicCustomOp.builder("clipbyvalue").addInputs(output).callInplace(true).addFloatingPointArguments(this.clipEps, 1.0 - this.clipEps).build();
            Nd4j.getExecutioner().execAndReturn(op);
        }
        INDArray numerator = output.sub(labels);
        INDArray denominator = Nd4j.getExecutioner().exec(new TimesOneMinus(output));
        INDArray dLda = numerator.divi(denominator);
        if (mask != null && LossUtil.isPerOutputMasking(dLda, mask)) {
            LossUtil.applyMask(dLda, mask);
        }
        INDArray grad = activationFn.backprop(preOutput, dLda).getFirst();
        if (this.weights != null) {
            if (this.weights.length() != output.size(1)) {
                throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + output.size(1));
            }
            grad.muliRowVector(this.weights.castTo(grad.dataType()));
        }
        if (mask != null) {
            LossUtil.applyMask(grad, mask);
        }
        return grad;
    }

    @Override
    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        return new Pair<Double, INDArray>(this.computeScore(labels, preOutput, activationFn, mask, average), this.computeGradient(labels, preOutput, activationFn, mask));
    }

    @Override
    public String name() {
        return this.toString();
    }

    public String toString() {
        if (this.weights == null) {
            return "LossBinaryXENT()";
        }
        return "LossBinaryXENT(weights=" + this.weights + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LossBinaryXENT)) {
            return false;
        }
        LossBinaryXENT other = (LossBinaryXENT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$weights = this.getWeights();
        INDArray other$weights = other.getWeights();
        if (this$weights == null ? other$weights != null : !this$weights.equals(other$weights)) {
            return false;
        }
        return Double.compare(this.getClipEps(), other.getClipEps()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LossBinaryXENT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : $weights.hashCode());
        long $clipEps = Double.doubleToLongBits(this.getClipEps());
        result = result * 59 + (int)($clipEps >>> 32 ^ $clipEps);
        return result;
    }

    public INDArray getWeights() {
        return this.weights;
    }

    public double getClipEps() {
        return this.clipEps;
    }

    public void setClipEps(double clipEps) {
        this.clipEps = clipEps;
    }
}

