/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import lombok.NonNull;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.conditions.EqualsCondition;
import org.nd4j.list.BaseNDArrayList;

public class NDArrayList
extends BaseNDArrayList<Double> {
    private INDArray container;
    private int size;

    public NDArrayList(int size) {
        this(DataType.DOUBLE, size);
    }

    public NDArrayList(DataType dataType, int size) {
        Preconditions.checkState(size >= 0, "Size must be non-negative - got %s", size);
        this.container = Nd4j.create(dataType, Math.max(10L, (long)size));
        this.size = size;
    }

    public NDArrayList(@NonNull INDArray container, int size) {
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        Preconditions.checkState(container == null || container.rank() == 1, "Container must be rank 1: is rank %s", container == null ? 0 : container.rank());
        this.container = container;
        this.size = size;
    }

    public NDArrayList() {
        this(0);
    }

    public NDArrayList(@NonNull INDArray container) {
        this(container, 0);
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
    }

    @Override
    public INDArray array() {
        if (this.isEmpty()) {
            throw new ND4JIllegalStateException("Array is empty!");
        }
        return this.container.get(NDArrayIndex.interval(0, this.size));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<Double> iterator() {
        return new NDArrayListIterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Double aDouble) {
        if (this.container == null) {
            this.container = Nd4j.create(10L);
        } else if ((long)this.size == this.container.length()) {
            INDArray newContainer = Nd4j.create(this.container.length() * 2L);
            newContainer.put(new INDArrayIndex[]{NDArrayIndex.interval(0L, this.container.length())}, this.container);
            this.container = newContainer;
        }
        this.container.putScalar((long)this.size++, (double)aDouble);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int idx = BooleanIndexing.firstIndex(this.container, new EqualsCondition((double)((Double)o))).getInt(0);
        if (idx < 0) {
            return false;
        }
        this.container.put(new INDArrayIndex[]{NDArrayIndex.interval((long)idx, this.container.length())}, this.container.get(NDArrayIndex.interval((long)(idx + 1), this.container.length())));
        this.container = this.container.reshape(this.size);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object d : collection) {
            if (this.contains(d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        if (collection instanceof NDArrayList) {
            NDArrayList ndArrayList = (NDArrayList)collection;
            this.growCapacity(this.size() + collection.size());
            this.container.put(new INDArrayIndex[]{NDArrayIndex.interval(this.size, this.size + collection.size())}, ndArrayList.container.get(NDArrayIndex.interval(0, ndArrayList.size())));
            this.size += ndArrayList.size();
        } else {
            for (Double d : collection) {
                this.add(d);
            }
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection<? extends Double> collection) {
        for (Double d : collection) {
            this.add(i, d);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        for (Object d : collection) {
            this.remove(d);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.container = null;
    }

    @Override
    public Double get(int i) {
        return this.container.getDouble((long)i);
    }

    @Override
    public Double set(int i, Double aDouble) {
        this.container.putScalar((long)i, (double)aDouble);
        return aDouble;
    }

    @Override
    public void add(int i, Double aDouble) {
        this.rangeCheck(i);
        this.growCapacity(i);
        this.moveForward(i);
        this.container.putScalar((long)i, (double)aDouble);
        ++this.size;
    }

    @Override
    public Double remove(int i) {
        this.rangeCheck(i);
        int numMoved = this.size - i - 1;
        if (numMoved > 0) {
            double move = this.container.getDouble((long)i);
            this.moveBackward(i);
            --this.size;
            return move;
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        return BooleanIndexing.firstIndex(this.container, new EqualsCondition((double)((Double)o))).getInt(0);
    }

    @Override
    public int lastIndexOf(Object o) {
        return BooleanIndexing.lastIndex(this.container, new EqualsCondition((double)((Double)o))).getInt(0);
    }

    @Override
    public ListIterator<Double> listIterator() {
        return new NDArrayListIterator();
    }

    @Override
    public ListIterator<Double> listIterator(int i) {
        return new NDArrayListIterator(i);
    }

    @Override
    public List<Double> subList(int i, int i1) {
        return new NDArrayList(this.container.get(NDArrayIndex.interval(i, i1)));
    }

    @Override
    public String toString() {
        return this.container.get(NDArrayIndex.interval(0, this.size)).toString();
    }

    private void growCapacity(int idx) {
        if (this.container == null) {
            this.container = Nd4j.create(10L);
        } else if ((long)idx >= this.container.length()) {
            long max = Math.max(this.container.length() * 2L, (long)idx);
            INDArray newContainer = Nd4j.create(max);
            newContainer.put(new INDArrayIndex[]{NDArrayIndex.interval(0L, this.container.length())}, this.container);
            this.container = newContainer;
        }
    }

    private void rangeCheck(int idx) {
        if (idx < 0 || idx > this.size) {
            throw new IllegalArgumentException("Illegal index " + idx);
        }
    }

    private void moveBackward(int index) {
        int numMoved = this.size - index - 1;
        INDArrayIndex[] first = new INDArrayIndex[]{NDArrayIndex.interval(index, index + numMoved)};
        INDArrayIndex[] getRange = new INDArrayIndex[]{NDArrayIndex.interval(index + 1, index + 1 + numMoved)};
        this.container.put(first, this.container.get(getRange));
    }

    private void moveForward(int index) {
        int numMoved = this.size - index - 1;
        INDArrayIndex[] getRange = new INDArrayIndex[]{NDArrayIndex.interval(index, index + numMoved)};
        INDArray get = this.container.get(getRange).dup();
        INDArrayIndex[] first = new INDArrayIndex[]{NDArrayIndex.interval((long)(index + 1), (long)(index + 1) + get.length())};
        this.container.put(first, get);
    }

    private class NDArrayListIterator
    implements ListIterator<Double> {
        private int curr = 0;

        NDArrayListIterator(int curr) {
            this.curr = curr;
        }

        NDArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.curr < NDArrayList.this.size;
        }

        @Override
        public Double next() {
            double ret = NDArrayList.this.get(this.curr);
            ++this.curr;
            return ret;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public Double previous() {
            double ret = NDArrayList.this.get(this.curr - 1);
            --this.curr;
            return ret;
        }

        @Override
        public int nextIndex() {
            return this.curr + 1;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Double aDouble) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double aDouble) {
            throw new UnsupportedOperationException();
        }
    }
}

