/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.rng;

import java.util.concurrent.atomic.AtomicLong;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.ops.random.impl.UniformDistribution;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeRandom
implements Random {
    private static final Logger log = LoggerFactory.getLogger(NativeRandom.class);
    protected NativeOps nativeOps;
    protected Pointer statePointer;
    protected AtomicLong currentPosition = new AtomicLong(0L);
    protected double z0;
    protected double z1;
    protected double u0;
    protected double u1;
    protected boolean generated = false;
    protected double mean = 0.0;
    protected double stdDev = 1.0;
    protected long seed;

    public NativeRandom() {
        this(System.currentTimeMillis());
    }

    public NativeRandom(long seed) {
        this(seed, 10000000L);
    }

    public NativeRandom(long seed, long numberOfElements) {
        this.seed = seed;
        this.init();
    }

    public abstract void init();

    @Override
    public void setSeed(int seed) {
        this.setSeed((long)seed);
    }

    @Override
    public void setSeed(int[] seed) {
        long sd = 0L;
        for (int em : seed) {
            sd *= (long)em;
        }
        this.setSeed(sd);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextInt(int to) {
        int r = this.nextInt();
        int m = to - 1;
        if ((to & m) == 0) {
            r = (int)((long)to * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % to) + m < 0) {
                u = this.nextInt();
            }
        }
        return r;
    }

    @Override
    public int nextInt(int a, int n) {
        return this.nextInt(n - a) + a;
    }

    public abstract PointerPointer getExtraPointers();

    @Override
    public boolean nextBoolean() {
        return this.nextInt() % 2 == 0;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextInt() / 2.1474836E9f;
    }

    @Override
    public double nextDouble() {
        return (double)this.nextInt() / 2.147483647E9;
    }

    @Override
    public double nextGaussian() {
        double epsilon = 1.0E-15;
        double two_pi = Math.PI * 2;
        if (!this.generated) {
            do {
                this.u0 = this.nextDouble();
                this.u1 = this.nextDouble();
            } while (this.u0 <= epsilon);
            this.z0 = Math.sqrt(-2.0 * Math.log(this.u0)) * Math.cos(two_pi * this.u1);
            this.z1 = Math.sqrt(-2.0 * Math.log(this.u0)) * Math.sin(two_pi * this.u1);
            this.generated = true;
            return this.z0 * this.stdDev + this.mean;
        }
        this.generated = false;
        return this.z1 * this.stdDev + this.mean;
    }

    @Override
    public INDArray nextGaussian(int[] shape) {
        return this.nextGaussian(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextGaussian(long[] shape) {
        return this.nextGaussian(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextGaussian(char order, int[] shape) {
        INDArray array = Nd4j.createUninitialized(shape, order);
        GaussianDistribution op = new GaussianDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec(op, this);
        return array;
    }

    @Override
    public INDArray nextGaussian(char order, long[] shape) {
        INDArray array = Nd4j.createUninitialized(shape, order);
        GaussianDistribution op = new GaussianDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec(op, this);
        return array;
    }

    @Override
    public INDArray nextDouble(int[] shape) {
        return this.nextDouble(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextDouble(long[] shape) {
        return this.nextDouble(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextDouble(char order, int[] shape) {
        INDArray array = Nd4j.createUninitialized(shape, order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec(op, this);
        return array;
    }

    @Override
    public INDArray nextDouble(char order, long[] shape) {
        INDArray array = Nd4j.createUninitialized(shape, order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec(op, this);
        return array;
    }

    @Override
    public INDArray nextFloat(int[] shape) {
        return this.nextFloat(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextFloat(long[] shape) {
        return this.nextFloat(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextFloat(char order, int[] shape) {
        INDArray array = Nd4j.createUninitialized(shape, order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec(op, this);
        return array;
    }

    @Override
    public INDArray nextFloat(char order, long[] shape) {
        INDArray array = Nd4j.createUninitialized(shape, order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec(op, this);
        return array;
    }

    @Override
    public INDArray nextInt(int[] shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray nextInt(long[] shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray nextInt(int n, int[] shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray nextInt(int n, long[] shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pointer getStatePointer() {
        return this.statePointer;
    }

    @Override
    public void reSeed() {
        this.setSeed(System.currentTimeMillis());
    }

    @Override
    public void reSeed(long amplifier) {
        this.setSeed(amplifier);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public long getPosition() {
        return this.currentPosition.get();
    }
}

