/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.solaris;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.unix.solaris.LibKstat;
import oshi.util.FormatUtil;
import oshi.util.Util;

public class KstatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KstatUtil.class);
    private static LibKstat.KstatCtl kc = LibKstat.INSTANCE.kstat_open();

    private KstatUtil() {
    }

    public static String kstatDataLookupString(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = LibKstat.INSTANCE.kstat_data_lookup(ksp, name);
        if (p == null) {
            LOG.error("Failed lo lookup kstat value for key {}", (Object)name);
            return "";
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 0: {
                return new String(data.value.charc).trim();
            }
            case 1: {
                return Integer.toString(data.value.i32);
            }
            case 2: {
                return FormatUtil.toUnsignedString(data.value.ui32);
            }
            case 3: {
                return Long.toString(data.value.i64);
            }
            case 4: {
                return FormatUtil.toUnsignedString(data.value.ui64);
            }
            case 9: {
                return data.value.str.addr.getString(0L);
            }
        }
        LOG.error("Unimplemented kstat data type {}", (Object)data.data_type);
        return "";
    }

    public static long kstatDataLookupLong(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = LibKstat.INSTANCE.kstat_data_lookup(ksp, name);
        if (p == null) {
            LOG.error("Failed lo lookup kstat value on {}:{}:{} for key {}", new String(ksp.ks_module).trim(), ksp.ks_instance, new String(ksp.ks_name).trim(), name);
            return 0L;
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 1: {
                return data.value.i32;
            }
            case 2: {
                return FormatUtil.getUnsignedInt(data.value.ui32);
            }
            case 3: {
                return data.value.i64;
            }
            case 4: {
                return data.value.ui64;
            }
        }
        LOG.error("Unimplemented or non-numeric kstat data type {}", (Object)data.data_type);
        return 0L;
    }

    public static boolean kstatRead(LibKstat.Kstat ksp) {
        int retry = 0;
        while (0 > LibKstat.INSTANCE.kstat_read(kc, ksp, null)) {
            if (11 != Native.getLastError() || 5 <= ++retry) {
                LOG.error("Failed to read kstat {}:{}:{}", new String(ksp.ks_module).trim(), ksp.ks_instance, new String(ksp.ks_name).trim());
                return false;
            }
            Util.sleep(8 << retry);
        }
        return true;
    }

    public static LibKstat.Kstat kstatLookup(String module, int instance, String name) {
        int ret = LibKstat.INSTANCE.kstat_chain_update(kc);
        if (ret < 0) {
            LOG.error("Failed to update kstat chain");
            return null;
        }
        return LibKstat.INSTANCE.kstat_lookup(kc, module, instance, name);
    }

    public static List<LibKstat.Kstat> kstatLookupAll(String module, int instance, String name) {
        ArrayList<LibKstat.Kstat> kstats = new ArrayList<LibKstat.Kstat>();
        int ret = LibKstat.INSTANCE.kstat_chain_update(kc);
        if (ret < 0) {
            LOG.error("Failed to update kstat chain");
            return kstats;
        }
        for (LibKstat.Kstat ksp = LibKstat.INSTANCE.kstat_lookup(kc, module, instance, name); ksp != null; ksp = ksp.next()) {
            if (module != null && !module.equals(new String(ksp.ks_module).trim()) || instance >= 0 && instance != ksp.ks_instance || name != null && !name.equals(new String(ksp.ks_name).trim())) continue;
            kstats.add(ksp);
        }
        return kstats;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LibKstat.INSTANCE.kstat_close(kc);
            }
        });
    }
}

