/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.math.BigInteger;
import org.bytedeco.javacpp.indexer.ULongIndexer;

public class ULongArrayIndexer
extends ULongIndexer {
    protected long[] array;

    public ULongArrayIndexer(long[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public ULongArrayIndexer(long[] array, long ... sizes) {
        this(array, sizes, ULongArrayIndexer.strides(sizes));
    }

    public ULongArrayIndexer(long[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public long[] array() {
        return this.array;
    }

    @Override
    public BigInteger get(long i) {
        return ULongArrayIndexer.toBigInteger(this.array[(int)i]);
    }

    @Override
    public ULongIndexer get(long i, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = ULongArrayIndexer.toBigInteger(this.array[(int)i * (int)this.strides[0] + n]);
        }
        return this;
    }

    @Override
    public BigInteger get(long i, long j) {
        return ULongArrayIndexer.toBigInteger(this.array[(int)i * (int)this.strides[0] + (int)j]);
    }

    @Override
    public ULongIndexer get(long i, long j, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = ULongArrayIndexer.toBigInteger(this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n]);
        }
        return this;
    }

    @Override
    public BigInteger get(long i, long j, long k) {
        return ULongArrayIndexer.toBigInteger(this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k]);
    }

    @Override
    public BigInteger get(long ... indices) {
        return ULongArrayIndexer.toBigInteger(this.array[(int)this.index(indices)]);
    }

    @Override
    public ULongIndexer get(long[] indices, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = ULongArrayIndexer.toBigInteger(this.array[(int)this.index(indices) + n]);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long i, BigInteger l) {
        this.array[(int)i] = ULongArrayIndexer.fromBigInteger(l);
        return this;
    }

    @Override
    public ULongIndexer put(long i, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = ULongArrayIndexer.fromBigInteger(l[offset + n]);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long i, long j, BigInteger l) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = ULongArrayIndexer.fromBigInteger(l);
        return this;
    }

    @Override
    public ULongIndexer put(long i, long j, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = ULongArrayIndexer.fromBigInteger(l[offset + n]);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long i, long j, long k, BigInteger l) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = ULongArrayIndexer.fromBigInteger(l);
        return this;
    }

    @Override
    public ULongIndexer put(long[] indices, BigInteger l) {
        this.array[(int)this.index((long[])indices)] = ULongArrayIndexer.fromBigInteger(l);
        return this;
    }

    @Override
    public ULongIndexer put(long[] indices, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = ULongArrayIndexer.fromBigInteger(l[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

