/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.evaluation.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.nd4j.evaluation.classification.ConfusionMatrix;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.node.ArrayNode;
import org.nd4j.shade.jackson.databind.node.ObjectNode;

public class ConfusionMatrixDeserializer
extends JsonDeserializer<ConfusionMatrix<Integer>> {
    @Override
    public ConfusionMatrix<Integer> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode n = (JsonNode)jp.getCodec().readTree(jp);
        ArrayNode classesNode = (ArrayNode)n.get("classes");
        ArrayList<Integer> classes = new ArrayList<Integer>();
        for (JsonNode cn : classesNode) {
            classes.add(cn.asInt());
        }
        ConfusionMatrix<Integer> cm = new ConfusionMatrix<Integer>(classes);
        ObjectNode matrix = (ObjectNode)n.get("matrix");
        Iterator<Map.Entry<String, JsonNode>> matrixIter = matrix.fields();
        while (matrixIter.hasNext()) {
            Map.Entry<String, JsonNode> e = matrixIter.next();
            int actualClass = Integer.parseInt(e.getKey());
            ArrayNode an = (ArrayNode)e.getValue();
            ArrayNode innerMultiSetKey = (ArrayNode)an.get(0);
            ArrayNode innerMultiSetCount = (ArrayNode)an.get(1);
            Iterator<JsonNode> iterKey = innerMultiSetKey.iterator();
            Iterator<JsonNode> iterCnt = innerMultiSetCount.iterator();
            while (iterKey.hasNext()) {
                int predictedClass = iterKey.next().asInt();
                int count = iterCnt.next().asInt();
                cm.add(actualClass, predictedClass, count);
            }
        }
        return cm;
    }
}

