/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;

public class ConstantProtector {
    private static ConstantProtector ourInstance = new ConstantProtector();
    private List<DataBuffer> protectorLegacy = new CopyOnWriteArrayList<DataBuffer>();
    private List<Pair<DataBuffer, long[]>> protector = new CopyOnWriteArrayList<Pair<DataBuffer, long[]>>();
    private List<Map<LongShapeDescriptor, Pair<DataBuffer, long[]>>> deviceCache = new ArrayList<Map<LongShapeDescriptor, Pair<DataBuffer, long[]>>>();

    public static ConstantProtector getInstance() {
        return ourInstance;
    }

    private ConstantProtector() {
        this.purgeProtector();
    }

    public void purgeProtector() {
        this.protector = new CopyOnWriteArrayList<Pair<DataBuffer, long[]>>();
        this.deviceCache = new ArrayList<Map<LongShapeDescriptor, Pair<DataBuffer, long[]>>>();
        int numDevices = Nd4j.getAffinityManager().getNumberOfDevices();
        for (int i = 0; i < numDevices; ++i) {
            this.deviceCache.add(i, new ConcurrentHashMap());
        }
    }

    public void persistDataBuffer(DataBuffer buffer) {
        this.protectorLegacy.add(buffer);
    }

    public void persistDataBuffer(Pair<DataBuffer, long[]> buffer) {
        this.protector.add(buffer);
    }

    public void persistDataBuffer(int deviceId, ShapeDescriptor descriptor, Pair<DataBuffer, long[]> buffer) {
        this.deviceCache.get(deviceId).put(LongShapeDescriptor.fromShapeDescriptor(descriptor), buffer);
    }

    public void persistDataBuffer(int deviceId, LongShapeDescriptor descriptor, Pair<DataBuffer, long[]> buffer) {
        this.deviceCache.get(deviceId).put(descriptor, buffer);
    }

    public Pair<DataBuffer, long[]> getDataBuffer(int deviceId, ShapeDescriptor descriptor) {
        return this.deviceCache.get(deviceId).get(LongShapeDescriptor.fromShapeDescriptor(descriptor));
    }

    public Pair<DataBuffer, long[]> getDataBuffer(int deviceId, LongShapeDescriptor descriptor) {
        return this.deviceCache.get(deviceId).get(descriptor);
    }

    public boolean containsDataBuffer(int deviceId, ShapeDescriptor descriptor) {
        return this.deviceCache.get(deviceId).containsKey(LongShapeDescriptor.fromShapeDescriptor(descriptor));
    }

    public boolean containsDataBuffer(int deviceId, LongShapeDescriptor descriptor) {
        return this.deviceCache.get(deviceId).containsKey(descriptor);
    }
}

