/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.ReduceSameOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;

public abstract class BaseReduceSameOp
extends BaseReduceOp
implements ReduceSameOp {
    public BaseReduceSameOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    protected BaseReduceSameOp(SameDiff sameDiff, SDVariable input, int[] dimensions, boolean keepDims) {
        super(sameDiff, input, dimensions, keepDims);
    }

    protected BaseReduceSameOp(SameDiff sameDiff, SDVariable input, int ... dimensions) {
        super(sameDiff, input, dimensions);
    }

    public BaseReduceSameOp(INDArray x, INDArray z, boolean keepDims, int[] dimensions) {
        super(x, null, z, keepDims, dimensions);
    }

    public BaseReduceSameOp(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        super(x, y, z, dimensions);
    }

    public BaseReduceSameOp(INDArray x, int ... dimensions) {
        super(x, dimensions);
    }

    public BaseReduceSameOp(INDArray x, boolean keepDims, int ... dimensions) {
        super(x, keepDims, dimensions);
    }

    protected BaseReduceSameOp() {
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE_SAME;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public DataType resultType() {
        return this.x().dataType();
    }

    @Override
    public DataType resultType(OpContext oc) {
        return oc.getInputArray(0).dataType();
    }

    @Override
    public boolean validateDataTypes(OpContext oc) {
        INDArray z;
        INDArray y;
        INDArray x = oc != null ? oc.getInputArray(0) : this.x();
        INDArray iNDArray = y = oc != null ? oc.getInputArray(1) : this.y();
        if (y != null) {
            Preconditions.checkArgument(x.dataType() == y.dataType(), "Op.X type must be the same as Op.Y type: x.dataType=%s, y.dataType=%s, op=%s", (Object)x.dataType(), (Object)y.dataType(), (Object)this.getClass().getName());
        }
        INDArray iNDArray2 = z = oc != null ? oc.getOutputArray(0) : this.z();
        if (z != null) {
            Preconditions.checkArgument(z.dataType() == x.dataType(), "Op.Z must be the same as Op.X type. Op.X.datatype=%s, Op.Z.datatype=%s", (Object)x.dataType(), (Object)z.dataType());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        INDArray x;
        INDArray iNDArray = x = oc != null ? oc.getInputArray(0) : this.x();
        if (x == null) {
            return Collections.emptyList();
        }
        long[] reducedShape = x.rank() == 0 ? x.shape() : Shape.getReducedShape(x.shape(), this.dimensions, this.isKeepDims());
        DataType rt = oc != null ? this.resultType(oc) : this.resultType();
        return Collections.singletonList(LongShapeDescriptor.fromShape(reducedShape, rt));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2), "Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState(dataTypes.size() == 1 || dataTypes.get(1).isIntType(), "When executing reductionswith 2 inputs, second input (axis) must be an integer datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

