/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthwiseConv2DBp
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DepthwiseConv2DBp.class);
    protected Conv2DConfig config;

    public DepthwiseConv2DBp(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull SDVariable gradO, @NonNull Conv2DConfig config) {
        super(sameDiff, DepthwiseConv2DBp.wrapFilterNull(input, weights, bias, gradO));
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (gradO == null) {
            throw new NullPointerException("gradO is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.addArgs();
    }

    public DepthwiseConv2DBp(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, @NonNull SDVariable gradO, @NonNull Conv2DConfig config) {
        super(sameDiff, DepthwiseConv2DBp.wrapFilterNull(input, weights, gradO));
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (gradO == null) {
            throw new NullPointerException("gradO is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.addArgs();
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    protected void addArgs() {
        this.addIArgument(this.config.getKH(), this.config.getKW(), this.config.getSH(), this.config.getSW(), this.config.getPH(), this.config.getPW(), this.config.getDH(), this.config.getDW(), ArrayUtil.fromBoolean(this.config.isSameMode()), this.config.getDataFormat().equalsIgnoreCase("NCHW") ? 0L : 1L);
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = Conv2DConfig.builder().build();
        }
        try {
            Object t = this.config.getValue(property);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = Conv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).isSameMode((Long)this.iArguments.get(8) == 1L).dataFormat((Long)this.iArguments.get(9) == 1L ? "NHWC" : "NCHW").build();
        }
        return this.config.toProperties();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String opName() {
        return "depthwise_conv2d_bp";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        ArrayList<DataType> list = new ArrayList<DataType>();
        for (int i = 0; i < n - 1; ++i) {
            list.add(inputDataTypes.get(0));
        }
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return list;
    }

    @Override
    public int getNumOutputs() {
        return this.args().length == 4 ? 3 : 2;
    }

    public Conv2DConfig getConfig() {
        return this.config;
    }

    public DepthwiseConv2DBp() {
    }
}

