/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling3dBp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling3d
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Upsampling3d.class);
    protected boolean ncdhw;
    protected int scaleH;
    protected int scaleW;
    protected int scaleD;

    public Upsampling3d(SameDiff sameDiff, SDVariable input, boolean ncdhw, int scaleD, int scaleH, int scaleW) {
        super("upsampling3d", sameDiff, new SDVariable[]{input});
        this.ncdhw = ncdhw;
        this.scaleD = scaleD;
        this.scaleH = scaleH;
        this.scaleW = scaleW;
        this.addIArgument(scaleD);
        this.addIArgument(scaleH);
        this.addIArgument(scaleW);
        this.addIArgument(scaleD);
        this.addIArgument(ncdhw ? 1 : 0);
    }

    public Upsampling3d(INDArray input, boolean ncdhw, int scaleH, int scaleW, int scaleD) {
        super(new INDArray[]{input}, null);
        this.ncdhw = ncdhw;
        this.scaleD = scaleD;
        this.scaleH = scaleH;
        this.scaleW = scaleW;
        this.addIArgument(scaleD);
        this.addIArgument(scaleH);
        this.addIArgument(scaleW);
        this.addIArgument(scaleD);
        this.addIArgument(ncdhw ? 0 : 1);
    }

    @Override
    public String opName() {
        return "upsampling3d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Arrays.asList(new Upsampling3dBp(this.sameDiff, this.arg(0), f1.get(0), this.ncdhw).outputVariables());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 1, "Expected 1 input data type for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public boolean isNcdhw() {
        return this.ncdhw;
    }

    public int getScaleH() {
        return this.scaleH;
    }

    public int getScaleW() {
        return this.scaleW;
    }

    public int getScaleD() {
        return this.scaleD;
    }

    public Upsampling3d() {
    }
}

