/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.RnnDataFormat;

public class LSTMConfiguration {
    private boolean peepHole;
    private RnnDataFormat dataFormat;
    private double forgetBias;
    private double clippingCellValue;

    public Map<String, Object> toProperties(boolean includeDataFormat) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("peepHole", this.peepHole);
        ret.put("clippingCellValue", this.clippingCellValue);
        ret.put("forgetBias", this.forgetBias);
        if (includeDataFormat) {
            ret.put("dataFormat", (Object)this.dataFormat);
        }
        return ret;
    }

    public int[] iArgs(boolean includeDataFormat) {
        if (includeDataFormat) {
            return new int[]{ArrayUtil.fromBoolean(this.peepHole), this.dataFormat.ordinal()};
        }
        return new int[]{ArrayUtil.fromBoolean(this.peepHole)};
    }

    public double[] tArgs() {
        return new double[]{this.forgetBias, this.clippingCellValue};
    }

    private static RnnDataFormat $default$dataFormat() {
        return RnnDataFormat.TNS;
    }

    LSTMConfiguration(boolean peepHole, RnnDataFormat dataFormat, double forgetBias, double clippingCellValue) {
        this.peepHole = peepHole;
        this.dataFormat = dataFormat;
        this.forgetBias = forgetBias;
        this.clippingCellValue = clippingCellValue;
    }

    public static LSTMConfigurationBuilder builder() {
        return new LSTMConfigurationBuilder();
    }

    public boolean isPeepHole() {
        return this.peepHole;
    }

    public RnnDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public double getForgetBias() {
        return this.forgetBias;
    }

    public double getClippingCellValue() {
        return this.clippingCellValue;
    }

    public void setPeepHole(boolean peepHole) {
        this.peepHole = peepHole;
    }

    public void setDataFormat(RnnDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setForgetBias(double forgetBias) {
        this.forgetBias = forgetBias;
    }

    public void setClippingCellValue(double clippingCellValue) {
        this.clippingCellValue = clippingCellValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LSTMConfiguration)) {
            return false;
        }
        LSTMConfiguration other = (LSTMConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPeepHole() != other.isPeepHole()) {
            return false;
        }
        RnnDataFormat this$dataFormat = this.getDataFormat();
        RnnDataFormat other$dataFormat = other.getDataFormat();
        if (this$dataFormat == null ? other$dataFormat != null : !((Object)((Object)this$dataFormat)).equals((Object)other$dataFormat)) {
            return false;
        }
        if (Double.compare(this.getForgetBias(), other.getForgetBias()) != 0) {
            return false;
        }
        return Double.compare(this.getClippingCellValue(), other.getClippingCellValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LSTMConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPeepHole() ? 79 : 97);
        RnnDataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : ((Object)((Object)$dataFormat)).hashCode());
        long $forgetBias = Double.doubleToLongBits(this.getForgetBias());
        result = result * 59 + (int)($forgetBias >>> 32 ^ $forgetBias);
        long $clippingCellValue = Double.doubleToLongBits(this.getClippingCellValue());
        result = result * 59 + (int)($clippingCellValue >>> 32 ^ $clippingCellValue);
        return result;
    }

    public String toString() {
        return "LSTMConfiguration(peepHole=" + this.isPeepHole() + ", dataFormat=" + (Object)((Object)this.getDataFormat()) + ", forgetBias=" + this.getForgetBias() + ", clippingCellValue=" + this.getClippingCellValue() + ")";
    }

    public static class LSTMConfigurationBuilder {
        private boolean peepHole;
        private boolean dataFormat$set;
        private RnnDataFormat dataFormat$value;
        private double forgetBias;
        private double clippingCellValue;

        LSTMConfigurationBuilder() {
        }

        public LSTMConfigurationBuilder peepHole(boolean peepHole) {
            this.peepHole = peepHole;
            return this;
        }

        public LSTMConfigurationBuilder dataFormat(RnnDataFormat dataFormat) {
            this.dataFormat$value = dataFormat;
            this.dataFormat$set = true;
            return this;
        }

        public LSTMConfigurationBuilder forgetBias(double forgetBias) {
            this.forgetBias = forgetBias;
            return this;
        }

        public LSTMConfigurationBuilder clippingCellValue(double clippingCellValue) {
            this.clippingCellValue = clippingCellValue;
            return this;
        }

        public LSTMConfiguration build() {
            RnnDataFormat dataFormat$value = this.dataFormat$value;
            if (!this.dataFormat$set) {
                dataFormat$value = LSTMConfiguration.$default$dataFormat();
            }
            return new LSTMConfiguration(this.peepHole, dataFormat$value, this.forgetBias, this.clippingCellValue);
        }

        public String toString() {
            return "LSTMConfiguration.LSTMConfigurationBuilder(peepHole=" + this.peepHole + ", dataFormat$value=" + (Object)((Object)this.dataFormat$value) + ", forgetBias=" + this.forgetBias + ", clippingCellValue=" + this.clippingCellValue + ")";
        }
    }
}

