/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce;

import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class MmulBp
extends DynamicCustomOp {
    protected MMulTranspose mt;

    public MmulBp(SameDiff sameDiff, SDVariable x, SDVariable y, SDVariable eps, MMulTranspose mt) {
        super(null, sameDiff, new SDVariable[]{x, y, eps});
        this.mt = mt;
        this.addIArgument(ArrayUtil.fromBoolean(mt.isTransposeA()), ArrayUtil.fromBoolean(mt.isTransposeB()), ArrayUtil.fromBoolean(mt.isTransposeResult()));
    }

    public MmulBp(SameDiff sameDiff, SDVariable x, SDVariable y, SDVariable eps) {
        this(sameDiff, x, y, eps, MMulTranspose.allFalse());
    }

    public MmulBp(INDArray x, INDArray y, INDArray eps, INDArray dldx, INDArray dldy, MMulTranspose mt) {
        super(null, new INDArray[]{x, y, eps}, new INDArray[]{dldx, dldy});
        if (mt != null) {
            this.mt = mt;
            this.addIArgument(ArrayUtil.fromBoolean(mt.isTransposeA()), ArrayUtil.fromBoolean(mt.isTransposeB()), ArrayUtil.fromBoolean(mt.isTransposeResult()));
        }
    }

    public MmulBp() {
    }

    @Override
    public String opName() {
        return "matmul_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        throw new UnsupportedOperationException("Differentiation of " + this.getClass().getName() + " not supported");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && dataTypes.size() == 3, "Expected exactly 3 inputs to matmul_bp op, got %s", dataTypes);
        Preconditions.checkState(dataTypes.get(0).isFPType() && dataTypes.get(1).isFPType() && dataTypes.get(0).isFPType(), "Inputs to matmul_bp op must both be a floatingpoint type: got %s", dataTypes);
        return dataTypes.subList(0, 2);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MmulBp)) {
            return false;
        }
        MmulBp other = (MmulBp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MMulTranspose this$mt = this.mt;
        MMulTranspose other$mt = other.mt;
        return !(this$mt == null ? other$mt != null : !((Object)this$mt).equals(other$mt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MmulBp;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MMulTranspose $mt = this.mt;
        result = result * 59 + ($mt == null ? 43 : ((Object)$mt).hashCode());
        return result;
    }
}

