/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.shade.guava.primitives.Ints;
import org.nd4j.shade.guava.primitives.Longs;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class TensorMmul
extends DynamicCustomOp {
    private int[][] axes;
    protected boolean addedEdges;
    protected MMulTranspose mMulTranspose;

    public TensorMmul(INDArray x, INDArray y, int[][] axes) {
        this(x, y, axes[0], axes[1], false, false, false);
    }

    public TensorMmul(INDArray x, INDArray y, INDArray z, int[][] axes) {
        this(x, y, axes[0], axes[1], false, false, false);
    }

    public TensorMmul(INDArray x, INDArray y, int[] dimensionsX, int[] dimensionsY, boolean transposeX, boolean transposeY, boolean transposeZ) {
        super(null, new INDArray[]{x, y}, null);
        this.axes = new int[][]{dimensionsX, dimensionsY};
        this.addIArgument(dimensionsX.length);
        this.addIArgument(dimensionsX);
        this.addIArgument(dimensionsY.length);
        this.addIArgument(dimensionsY);
        this.addBArgument(transposeX, transposeY, transposeZ);
    }

    public TensorMmul(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[][] dimensions) {
        this(sameDiff, i_v1, i_v2, dimensions, MMulTranspose.allFalse());
    }

    public TensorMmul(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[][] dimensions, MMulTranspose mMulTranspose) {
        super(null, sameDiff, new SDVariable[]{i_v1, i_v2});
        this.sameDiff = sameDiff;
        this.mMulTranspose = mMulTranspose;
        this.axes = dimensions;
        if (!this.addedEdges && sameDiff.getOutputsForOp(this) == null) {
            this.addedEdges = true;
        }
        this.addIArgument(dimensions[0].length);
        this.addIArgument(dimensions[0]);
        this.addIArgument(dimensions[1].length);
        this.addIArgument(dimensions[1]);
    }

    public TensorMmul(SameDiff sameDiff, SDVariable x, SDVariable y, int[] dimensionsX, int[] dimensionsY, boolean transposeX, boolean transposeY, boolean transposeZ) {
        super(null, sameDiff, new SDVariable[]{x, y});
        this.sameDiff = sameDiff;
        this.axes = new int[][]{dimensionsX, dimensionsY};
        this.addIArgument(dimensionsX.length);
        this.addIArgument(dimensionsX[0]);
        this.addIArgument(dimensionsY.length);
        this.addIArgument(dimensionsY[0]);
        this.addBArgument(transposeX, transposeY, transposeZ);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        long[] bShape;
        ArrayList<LongShapeDescriptor> ret = new ArrayList<LongShapeDescriptor>(1);
        long[] aShape = this.mMulTranspose.isTransposeA() ? ArrayUtil.reverseCopy(this.larg().getShape()) : this.larg().getShape();
        long[] lArray = bShape = this.mMulTranspose.isTransposeB() ? ArrayUtil.reverseCopy(this.rarg().getShape()) : this.rarg().getShape();
        if (Shape.isPlaceholderShape(aShape) || Shape.isPlaceholderShape(bShape)) {
            return Collections.emptyList();
        }
        if (aShape != null && bShape != null) {
            long[] shape = ArrayUtil.getTensorMmulShape(aShape, bShape, this.axes);
            ret.add(LongShapeDescriptor.fromShape(shape, Shape.pickPairwiseDataType(this.larg().dataType(), this.rarg().dataType())));
        }
        if (!ret.isEmpty()) {
            for (int i = 0; i < ((LongShapeDescriptor)ret.get(0)).getShape().length; ++i) {
                if (((LongShapeDescriptor)ret.get(0)).getShape()[i] >= 1L) continue;
                throw new ND4JIllegalStateException("Invalid shape computed at index " + i);
            }
        }
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        int[] bAxes = ArrayUtil.range(0, this.rarg().getShape().length);
        int[] aAxes = ArrayUtil.range(0, this.larg().getShape().length);
        int aRank = this.larg().getShape().length;
        int bRank = this.rarg().getShape().length;
        int[][] sumAxes = new int[][]{ArrayUtil.mod(this.axes[0], aRank), ArrayUtil.mod(this.axes[1], bRank)};
        int[][] deletedAxes = new int[][]{ArrayUtil.removeIndex(aAxes, sumAxes[0]), ArrayUtil.removeIndex(bAxes, sumAxes[1])};
        int[] gAxes = ArrayUtil.range(0, i_v1.get(0).eval().shape().length);
        int[][] firstAxes = new int[][]{Arrays.copyOfRange(gAxes, deletedAxes[0].length, gAxes.length), deletedAxes[1]};
        int[][] secondAxes = new int[][]{deletedAxes[0], Arrays.copyOfRange(gAxes, 0, deletedAxes[0].length)};
        int[] firstPerm = ArrayUtil.argsort(ArrayUtil.combine(deletedAxes[0], ArrayUtil.keep(ArrayUtil.argsort(sumAxes[1]), sumAxes[0])));
        SDVariable firstResult = this.doTensorMmul(i_v1.get(0), this.rarg(), firstAxes);
        SDVariable permuted = this.sameDiff.permute(firstResult, firstPerm);
        ret.add(permuted);
        int[] secondPerm = ArrayUtil.argsort(ArrayUtil.combine(ArrayUtil.keep(ArrayUtil.argsort(sumAxes[0]), sumAxes[1]), deletedAxes[1]));
        SDVariable secondResult = this.doTensorMmul(i_v1.get(0), this.larg(), secondAxes);
        SDVariable secondPermuted = this.sameDiff.permute(secondResult, secondPerm);
        ret.add(secondPermuted);
        return ret;
    }

    private SDVariable doTensorMmul(SDVariable a, SDVariable b, int[][] axes) {
        long[] oldShapeB;
        long[] oldShapeA;
        int validationLength = Math.min(axes[0].length, axes[1].length);
        INDArray aArray = a.eval();
        INDArray bArray = b.eval();
        for (int i = 0; i < validationLength; ++i) {
            if (aArray.shape()[axes[0][i]] != bArray.shape()[axes[1][i]]) {
                throw new IllegalArgumentException("Size of the given axes at each dimension must be the same size.");
            }
            if (axes[0][i] < 0) {
                int[] nArray = axes[0];
                int n = i;
                nArray[n] = nArray[n] + aArray.shape().length;
            }
            if (axes[1][i] >= 0) continue;
            int[] nArray = axes[1];
            int n = i;
            nArray[n] = nArray[n] + bArray.shape().length;
        }
        ArrayList<Integer> listA = new ArrayList<Integer>();
        for (int i = 0; i < aArray.shape().length; ++i) {
            if (Ints.contains(axes[0], i)) continue;
            listA.add(i);
        }
        int[] newAxesA = Ints.concat(Ints.toArray(listA), axes[0]);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        for (int i = 0; i < bArray.shape().length; ++i) {
            if (Ints.contains(axes[1], i)) continue;
            listB.add(i);
        }
        int[] newAxesB = Ints.concat(axes[1], Ints.toArray(listB));
        int n2 = 1;
        int aLength = Math.min(aArray.shape().length, axes[0].length);
        for (int i = 0; i < aLength; ++i) {
            n2 = (int)((long)n2 * aArray.shape()[axes[0][i]]);
        }
        long[] newShapeA = new long[]{-1L, n2};
        if (listA.size() == 0) {
            oldShapeA = new long[]{1L};
        } else {
            oldShapeA = Longs.toArray(listA);
            for (int i = 0; i < oldShapeA.length; ++i) {
                oldShapeA[i] = aArray.shape()[(int)oldShapeA[i]];
            }
        }
        int n3 = 1;
        int bNax = Math.min(bArray.shape().length, axes[1].length);
        for (int i = 0; i < bNax; ++i) {
            n3 = (int)((long)n3 * bArray.shape()[axes[1][i]]);
        }
        long[] newShapeB = new long[]{n3, -1L};
        if (listB.size() == 0) {
            oldShapeB = new long[]{1L};
        } else {
            oldShapeB = Longs.toArray(listB);
            for (int i = 0; i < oldShapeB.length; ++i) {
                oldShapeB[i] = bArray.shape()[(int)oldShapeB[i]];
            }
        }
        SDVariable at = this.sameDiff.reshape(this.sameDiff.permute(a, newAxesA), newShapeA);
        SDVariable bt = this.sameDiff.reshape(this.sameDiff.permute(b, newAxesB), newShapeB);
        SDVariable ret = this.sameDiff.mmul(at, bt);
        long[] aPlusB = Longs.concat(oldShapeA, oldShapeB);
        return this.sameDiff.reshape(ret, aPlusB);
    }

    @Override
    public String opName() {
        return "tensordot";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        MMulTranspose mMulTranspose;
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        boolean isTransposeA = attributesForNode.get("transpose_a").getB();
        boolean isTransposeB = attributesForNode.get("transpose_b").getB();
        this.mMulTranspose = mMulTranspose = MMulTranspose.builder().transposeA(isTransposeA).transposeB(isTransposeB).build();
        SDVariable[] args = this.args();
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        MMulTranspose mMulTranspose;
        boolean isTransposeA;
        boolean bl = !attributesForNode.containsKey("transA") ? false : (isTransposeA = attributesForNode.get("transA").getI() > 0L);
        boolean isTransposeB = !attributesForNode.containsKey("transB") ? false : attributesForNode.get("transB").getI() > 0L;
        this.mMulTranspose = mMulTranspose = MMulTranspose.builder().transposeA(isTransposeA).transposeB(isTransposeB).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorMmul that = (TensorMmul)o;
        if (this.addedEdges != that.addedEdges) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.axes, (Object[])that.axes)) {
            return false;
        }
        return this.mMulTranspose != null ? this.mMulTranspose.equals(that.mMulTranspose) : that.mMulTranspose == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.deepHashCode((Object[])this.axes);
        result = 31 * result + (this.addedEdges ? 1 : 0);
        result = 31 * result + (this.mMulTranspose != null ? this.mMulTranspose.hashCode() : 0);
        return result;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public String onnxName() {
        return "Gemm";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 2, "Expected exactly 2 input data types for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public TensorMmul() {
    }
}

