/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.PReluBp;

public class PRelu
extends DynamicCustomOp {
    protected int[] sharedAxes;

    public PRelu(@NonNull SameDiff sameDiff, @NonNull SDVariable x, @NonNull SDVariable alpha, int ... sharedAxes) {
        super(sameDiff, new SDVariable[]{x, alpha});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (alpha == null) {
            throw new NullPointerException("alpha is marked non-null but is null");
        }
        if (sharedAxes == null) {
            throw new NullPointerException("sharedAxes is marked non-null but is null");
        }
        this.sharedAxes = sharedAxes;
        this.addIArgument(sharedAxes);
    }

    public PRelu(@NonNull INDArray x, @NonNull INDArray alpha, int ... sharedAxes) {
        this(x, null, alpha, sharedAxes);
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (alpha == null) {
            throw new NullPointerException("alpha is marked non-null but is null");
        }
        if (sharedAxes == null) {
            throw new NullPointerException("sharedAxes is marked non-null but is null");
        }
    }

    public PRelu(@NonNull INDArray x, INDArray z, @NonNull INDArray alpha, int ... sharedAxes) {
        super(new INDArray[]{x, alpha}, new INDArray[]{z});
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (alpha == null) {
            throw new NullPointerException("alpha is marked non-null but is null");
        }
        if (sharedAxes == null) {
            throw new NullPointerException("sharedAxes is marked non-null but is null");
        }
        this.sharedAxes = sharedAxes;
        this.addIArgument(sharedAxes);
    }

    @Override
    public String opName() {
        return "prelu";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkArgument(dataTypes != null && dataTypes.size() == 2, "Expected exactly 2 input datatypes, got %s", dataTypes);
        Preconditions.checkArgument(dataTypes.get(0).isFPType() && dataTypes.get(1).isFPType(), "Input datatypes must be floating point, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return new PReluBp(this.sameDiff, this.arg(0), this.arg(1), i_v.get(0), this.sharedAxes).outputs();
    }

    public PRelu() {
    }

    public int[] getSharedAxes() {
        return this.sharedAxes;
    }
}

