/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseRandomOp
extends BaseOp
implements RandomOp {
    protected long[] shape;
    protected DataType dataType = Nd4j.defaultFloatingPointType();

    public BaseRandomOp(SameDiff sameDiff, SDVariable i_v) {
        Preconditions.checkNotNull(i_v, "Input variable can't be null with this constructor");
        this.sameDiff = sameDiff;
        this.xVertexId = i_v.name();
        sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
    }

    public BaseRandomOp(SameDiff sd, long[] shape) {
        super(sd, (Object[])null);
        Preconditions.checkArgument(shape != null && shape.length > 0, "Shape must be non-null, length > 0. Got: %s", (Object)shape);
        this.sameDiff = sd;
        this.shape = shape;
        this.setInstanceId();
        this.sameDiff.addArgsFor(new String[0], (DifferentialFunction)this);
    }

    public BaseRandomOp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.RANDOM;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext opContext) {
        if (this.shape != null) {
            return Collections.singletonList(LongShapeDescriptor.fromShape(this.shape, this.dataType));
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(this.shape, Shape.pickPairwiseDataType(this.args()[0].dataType(), Nd4j.dataType())));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes == null || inputDataTypes.isEmpty(), "Expected no input data types for %s, got %s", (Object)this.getClass().getName(), inputDataTypes);
        return Collections.singletonList(DataType.FLOAT);
    }

    @Override
    public boolean isInPlace() {
        return this.x == null || this.x == this.z || this.x.data().pointer().address() == this.z.data().pointer().address();
    }

    public boolean isTripleArgRngOp() {
        return false;
    }

    public BaseRandomOp() {
    }
}

