/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.factory.Nd4j;

public class CropAndResizeDataSetPreProcessor
implements DataSetPreProcessor {
    private final long[] resizedShape;
    private final INDArray indices;
    private final INDArray resize;
    private final INDArray boxes;
    private final int method;

    public CropAndResizeDataSetPreProcessor(int originalHeight, int originalWidth, int cropYStart, int cropXStart, int resizedHeight, int resizedWidth, int numChannels, ResizeMethod resizeMethod) {
        Preconditions.checkArgument(originalHeight > 0, "originalHeight must be greater than 0, got %s", originalHeight);
        Preconditions.checkArgument(originalWidth > 0, "originalWidth must be greater than 0, got %s", originalWidth);
        Preconditions.checkArgument(cropYStart >= 0, "cropYStart must be greater or equal to 0, got %s", cropYStart);
        Preconditions.checkArgument(cropXStart >= 0, "cropXStart must be greater or equal to 0, got %s", cropXStart);
        Preconditions.checkArgument(resizedHeight > 0, "resizedHeight must be greater than 0, got %s", resizedHeight);
        Preconditions.checkArgument(resizedWidth > 0, "resizedWidth must be greater than 0, got %s", resizedWidth);
        Preconditions.checkArgument(numChannels > 0, "numChannels must be greater than 0, got %s", numChannels);
        this.resizedShape = new long[]{1L, resizedHeight, resizedWidth, numChannels};
        this.boxes = Nd4j.create(new float[]{(float)cropYStart / (float)originalHeight, (float)cropXStart / (float)originalWidth, (float)(cropYStart + resizedHeight) / (float)originalHeight, (float)(cropXStart + resizedWidth) / (float)originalWidth}, new long[]{1L, 4L}, DataType.FLOAT);
        this.indices = Nd4j.create(new int[]{0}, new long[]{1L, 1L}, DataType.INT);
        this.resize = Nd4j.create(new int[]{resizedHeight, resizedWidth}, new long[]{1L, 2L}, DataType.INT);
        this.method = resizeMethod == ResizeMethod.Bilinear ? 0 : 1;
    }

    @Override
    public void preProcess(DataSet dataSet) {
        Preconditions.checkNotNull(dataSet, "Encountered null dataSet");
        if (dataSet.isEmpty()) {
            return;
        }
        INDArray input = dataSet.getFeatures();
        INDArray output = Nd4j.create(LongShapeDescriptor.fromShape(this.resizedShape, input.dataType()), false);
        DynamicCustomOp op = DynamicCustomOp.builder("crop_and_resize").addInputs(input, this.boxes, this.indices, this.resize).addIntegerArguments((long)this.method).addOutputs(output).build();
        Nd4j.getExecutioner().exec(op);
        dataSet.setFeatures(output);
    }

    public static enum ResizeMethod {
        Bilinear,
        NearestNeighbor;

    }
}

