/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.eigen;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.inverse.InvertMatrix;

public class Eigen {
    public static INDArray dummy = Nd4j.scalar(1);

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A) {
        INDArray eigenvalues = Nd4j.create(A.dataType(), A.rows());
        Nd4j.getBlasWrapper().syev('V', 'L', A, eigenvalues);
        return eigenvalues;
    }

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A, boolean calculateVectors) {
        INDArray eigenvalues = Nd4j.create(A.dataType(), A.rows());
        Nd4j.getBlasWrapper().syev('V', 'L', calculateVectors ? A : A.dup(), eigenvalues);
        return eigenvalues;
    }

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A, INDArray B) {
        Preconditions.checkArgument(A.isMatrix() && A.isSquare(), "Argument A must be a square matrix: has shape %s", (Object)A.shape());
        Preconditions.checkArgument(B.isMatrix() && B.isSquare(), "Argument B must be a square matrix: has shape %s", (Object)B.shape());
        INDArray W = Nd4j.create(A.rows());
        A = InvertMatrix.invert(B, false).mmuli(A);
        Nd4j.getBlasWrapper().syev('V', 'L', A, W);
        return W;
    }

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A, INDArray B, boolean calculateVectors) {
        Preconditions.checkArgument(A.isMatrix() && A.isSquare(), "Argument A must be a square matrix: has shape %s", (Object)A.shape());
        Preconditions.checkArgument(B.isMatrix() && B.isSquare(), "Argument B must be a square matrix: has shape %s", (Object)B.shape());
        INDArray W = Nd4j.create(A.dataType(), A.rows());
        if (calculateVectors) {
            A.assign(InvertMatrix.invert(B, false).mmuli(A));
        } else {
            A = InvertMatrix.invert(B, false).mmuli(A);
        }
        Nd4j.getBlasWrapper().syev('V', 'L', A, W);
        return W;
    }
}

