/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bytedeco.cuda.global.cublas;
import org.bytedeco.cuda.global.cudart;
import org.bytedeco.javacpp.Loader;
import org.nd4j.common.io.ClassPathResource;
import org.nd4j.common.io.Resource;
import org.nd4j.linalg.api.environment.Nd4jEnvironment;
import org.nd4j.linalg.factory.Environment;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.factory.Nd4jBackend;
import org.nd4j.linalg.jcublas.JCublasNDArray;
import org.nd4j.nativeblas.CudaEnvironment;
import org.nd4j.nativeblas.Nd4jCuda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCublasBackend
extends Nd4jBackend {
    private static final Logger log = LoggerFactory.getLogger(JCublasBackend.class);
    private static final String LINALG_PROPS = "/nd4j-jcublas.properties";

    @Override
    public boolean isAvailable() {
        try {
            if (!this.canRun()) {
                return false;
            }
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean canRun() {
        int[] count = new int[]{0};
        cudart.cudaGetDeviceCount(count);
        if (count[0] <= 0) {
            throw new RuntimeException("No CUDA devices were found in system");
        }
        Loader.load(cublas.class);
        return true;
    }

    @Override
    public boolean allowsOrder() {
        return false;
    }

    @Override
    public int getPriority() {
        return BACKEND_PRIORITY_GPU;
    }

    @Override
    public Resource getConfigurationResource() {
        return new ClassPathResource(LINALG_PROPS, JCublasBackend.class.getClassLoader());
    }

    @Override
    public Class getNDArrayClass() {
        return JCublasNDArray.class;
    }

    @Override
    public Environment getEnvironment() {
        return CudaEnvironment.getInstance();
    }

    @Override
    public void logBackendInit() {
        String logInitProperty = System.getProperty("org.nd4j.log.initialization", "true");
        boolean logInit = Boolean.parseBoolean(logInitProperty);
        if (logInit) {
            try {
                Nd4jCuda.Environment e = Nd4jCuda.Environment.getInstance();
                int blasMajor = e.blasMajorVersion();
                int blasMinor = e.blasMinorVersion();
                int blasPatch = e.blasPatchVersion();
                log.info("ND4J CUDA build version: {}.{}.{}", blasMajor, blasMinor, blasPatch);
                int nGPUs = Nd4jEnvironment.getEnvironment().getNumGpus();
                Properties props = Nd4j.getExecutioner().getEnvironmentInformation();
                List devicesList = (List)props.get("cuda.devicesInformation");
                for (int i = 0; i < nGPUs; ++i) {
                    Map dev = (Map)devicesList.get(i);
                    String name = (String)dev.get("cuda.deviceName");
                    int major = ((Number)dev.get("cuda.deviceMajor")).intValue();
                    int minor = ((Number)dev.get("cuda.deviceMinor")).intValue();
                    long totalMem = ((Number)dev.get("cuda.totalMemory")).longValue();
                    log.info("CUDA device {}: [{}]; cc: [{}.{}]; Total memory: [{}]", i, name, major, minor, totalMem);
                }
            }
            catch (Throwable t) {
                log.debug("Error logging CUDA backend versions and devices", t);
            }
        }
    }
}

