/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.blas;

import org.bytedeco.cuda.cublas.cublasContext;
import org.bytedeco.cuda.cudart.CUstream_st;
import org.bytedeco.cuda.global.cublas;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.nd4j.jita.allocator.Allocator;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t;
import org.nd4j.linalg.api.blas.impl.BaseLevel2;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.linalg.jcublas.blas.CudaBlas;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcublasLevel2
extends BaseLevel2 {
    private Allocator allocator = AtomicAllocator.getInstance();
    private Nd4jBlas nd4jBlas = (Nd4jBlas)Nd4j.factory().blas();
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private static Logger logger = LoggerFactory.getLogger(JcublasLevel2.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sgemv(char order, char TransA, int M, int N, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        cublasHandle_t handle;
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, A, X);
        CublasPointer cAPointer = new CublasPointer(A, ctx);
        CublasPointer cBPointer = new CublasPointer(X, ctx);
        CublasPointer cCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2(new cublasContext(handle), new CUstream_st(ctx.getCublasStream()));
            cublas.cublasSgemv_v2(new cublasContext(handle), CudaBlas.convertTranspose(TransA), M, N, new FloatPointer(alpha), (FloatPointer)cAPointer.getDevicePointer(), lda, (FloatPointer)cBPointer.getDevicePointer(), incX, new FloatPointer(beta), (FloatPointer)cCPointer.getDevicePointer(), incY);
        }
        this.allocator.registerAction(ctx, Y, A, X);
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    protected void sgbmv(char order, char TransA, int M, int N, int KL, int KU, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void strmv(char order, char Uplo, char TransA, char Diag2, int N, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void stbmv(char order, char Uplo, char TransA, char Diag2, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void stpmv(char order, char Uplo, char TransA, char Diag2, int N, INDArray Ap, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void strsv(char order, char Uplo, char TransA, char Diag2, int N, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void stbsv(char order, char Uplo, char TransA, char Diag2, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void stpsv(char order, char Uplo, char TransA, char Diag2, int N, INDArray Ap, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dgemv(char order, char TransA, int M, int N, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        cublasHandle_t handle;
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, A, X);
        CublasPointer cAPointer = new CublasPointer(A, ctx);
        CublasPointer cBPointer = new CublasPointer(X, ctx);
        CublasPointer cCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getCublasHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2(new cublasContext(handle), new CUstream_st(ctx.getCublasStream()));
            cublas.cublasDgemv_v2(new cublasContext(handle), CudaBlas.convertTranspose(TransA), M, N, new DoublePointer(alpha), (DoublePointer)cAPointer.getDevicePointer(), lda, (DoublePointer)cBPointer.getDevicePointer(), incX, new DoublePointer(beta), (DoublePointer)cCPointer.getDevicePointer(), incY);
        }
        this.allocator.registerAction(ctx, Y, A, X);
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    protected void dgbmv(char order, char TransA, int M, int N, int KL, int KU, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dtrmv(char order, char Uplo, char TransA, char Diag2, int N, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dtbmv(char order, char Uplo, char TransA, char Diag2, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dtpmv(char order, char Uplo, char TransA, char Diag2, int N, INDArray Ap, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dtrsv(char order, char Uplo, char TransA, char Diag2, int N, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dtbsv(char order, char Uplo, char TransA, char Diag2, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dtpsv(char order, char Uplo, char TransA, char Diag2, int N, INDArray Ap, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void ssymv(char order, char Uplo, int N, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void ssbmv(char order, char Uplo, int N, int K, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void sspmv(char order, char Uplo, int N, float alpha, INDArray Ap, INDArray X, int incX, float beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void sger(char order, int M, int N, float alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void ssyr(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void sspr(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray Ap) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void ssyr2(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void sspr2(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dsymv(char order, char Uplo, int N, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dsbmv(char order, char Uplo, int N, int K, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dspmv(char order, char Uplo, int N, double alpha, INDArray Ap, INDArray X, int incX, double beta, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dger(char order, int M, int N, double alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dsyr(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dspr(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray Ap) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dsyr2(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dspr2(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A) {
        throw new UnsupportedOperationException();
    }
}

