/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import lombok.NonNull;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;

public class CudaUtf8Buffer
extends BaseCudaDataBuffer {
    protected Collection<Pointer> references = new ArrayList<Pointer>();
    protected long numWords = 0L;

    public CudaUtf8Buffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaUtf8Buffer(ByteBuffer buffer, DataType dataType, long length, long offset) {
        super(buffer, dataType, length, offset);
    }

    public CudaUtf8Buffer(long length) {
        super(length);
    }

    public CudaUtf8Buffer(long length, boolean initialize) {
        super((length + 1L) * 8L, 1, initialize);
        this.numWords = length;
    }

    public CudaUtf8Buffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super((length + 1L) * 8L, 1, initialize, workspace);
        this.numWords = length;
    }

    public CudaUtf8Buffer(int[] ints, boolean copy, MemoryWorkspace workspace) {
        super(ints, copy, workspace);
    }

    public CudaUtf8Buffer(byte[] data, long numWords) {
        super((long)data.length, 1, false);
        this.lazyAllocateHostPointer();
        BytePointer bp = (BytePointer)this.pointer;
        bp.put(data);
        this.numWords = numWords;
    }

    public CudaUtf8Buffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaUtf8Buffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaUtf8Buffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaUtf8Buffer(long[] data, boolean copy) {
        super(data, copy);
    }

    public CudaUtf8Buffer(long[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy);
    }

    public CudaUtf8Buffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaUtf8Buffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaUtf8Buffer(int length, int elementSize) {
        super(length, elementSize);
    }

    public CudaUtf8Buffer(int length, int elementSize, long offset) {
        super((long)length, elementSize, offset);
    }

    public CudaUtf8Buffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
        this.numWords = length;
        Preconditions.checkArgument(((CudaUtf8Buffer)underlyingBuffer).numWords == this.numWords, "String array can't be a view");
    }

    public CudaUtf8Buffer(@NonNull Collection<String> strings) {
        super(CudaUtf8Buffer.stringBufferRequiredLength(strings), 1, false);
        if (strings == null) {
            throw new NullPointerException("strings is marked non-null but is null");
        }
        this.lazyAllocateHostPointer();
        int headerLength = (strings.size() + 1) * 8;
        LongPointer headerPointer = new LongPointer(this.pointer);
        BytePointer dataPointer = new BytePointer(this.pointer);
        this.numWords = strings.size();
        long cnt = 0L;
        long currentLength = 0L;
        for (String s : strings) {
            headerPointer.put(cnt++, currentLength);
            int length = s.length();
            char[] chars = s.toCharArray();
            for (int e = 0; e < length; ++e) {
                byte b = (byte)chars[e];
                long idx = (long)headerLength + currentLength + (long)e;
                dataPointer.put(idx, b);
            }
            currentLength += (long)length;
        }
        headerPointer.put(cnt, currentLength);
        this.allocationPoint.tickHostWrite();
    }

    public String getString(long index) {
        if (index > this.numWords) {
            throw new IllegalArgumentException("Requested index [" + index + "] is above actual number of words stored: [" + this.numWords + "]");
        }
        LongPointer headerPointer = new LongPointer(this.pointer);
        BytePointer dataPointer = (BytePointer)this.pointer;
        long start = headerPointer.get(index);
        long end = headerPointer.get(index + 1L);
        if (end - start > Integer.MAX_VALUE) {
            throw new IllegalStateException("Array is too long for Java");
        }
        int dataLength = (int)(end - start);
        byte[] bytes = new byte[dataLength];
        long headerLength = (this.numWords + 1L) * 8L;
        for (int e = 0; e < dataLength; ++e) {
            long idx = headerLength + start + (long)e;
            bytes[e] = dataPointer.get(idx);
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected DataBuffer create(long length) {
        return new CudaUtf8Buffer(length);
    }

    @Override
    public DataBuffer create(double[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataBuffer create(float[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataBuffer create(int[] data) {
        throw new UnsupportedOperationException();
    }

    private static long stringBufferRequiredLength(@NonNull Collection<String> strings) {
        if (strings == null) {
            throw new NullPointerException("strings is marked non-null but is null");
        }
        long size = (strings.size() + 1) * 8;
        for (String s : strings) {
            size += (long)s.length();
        }
        return size;
    }

    public void put(long index, Pointer pointer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void initTypeAndSize() {
        this.elementSize = 1;
        this.type = DataType.UTF8;
    }

    public long getNumWords() {
        return this.numWords;
    }
}

