/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer.factory;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.jcublas.buffer.CudaBfloat16DataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaBoolDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaByteDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaDoubleDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaFloatDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaHalfDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaIntDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaLongDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaShortDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaUByteDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaUInt16DataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaUInt32DataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaUInt64DataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaUtf8Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaDataBufferFactory
implements DataBufferFactory {
    private static final Logger log = LoggerFactory.getLogger(CudaDataBufferFactory.class);
    protected DataBuffer.AllocationMode allocationMode;

    @Override
    public void setAllocationMode(DataBuffer.AllocationMode allocationMode) {
        this.allocationMode = allocationMode;
    }

    @Override
    public DataBuffer.AllocationMode allocationMode() {
        if (this.allocationMode == null) {
            String otherAlloc = System.getProperty("alloc");
            if (otherAlloc.equals("heap")) {
                this.setAllocationMode(DataBuffer.AllocationMode.HEAP);
            } else if (otherAlloc.equals("direct")) {
                this.setAllocationMode(DataBuffer.AllocationMode.DIRECT);
            } else if (otherAlloc.equals("javacpp")) {
                this.setAllocationMode(DataBuffer.AllocationMode.JAVACPP);
            }
        }
        return this.allocationMode;
    }

    @Override
    public DataBuffer create(ByteBuffer underlyingBuffer, DataType dataType, long length, long offset) {
        switch (dataType) {
            case DOUBLE: {
                return new CudaDoubleDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case HALF: {
                return new CudaHalfDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case BFLOAT16: {
                return new CudaBfloat16DataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case LONG: {
                return new CudaLongDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case INT: {
                return new CudaIntDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case SHORT: {
                return new CudaShortDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case UBYTE: {
                return new CudaUByteDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case UINT16: {
                return new CudaUInt16DataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case UINT32: {
                return new CudaUInt32DataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case UINT64: {
                return new CudaUInt64DataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case BYTE: {
                return new CudaByteDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case BOOL: {
                return new CudaBoolDataBuffer(underlyingBuffer, dataType, length, offset);
            }
            case UTF8: {
                return new CudaUtf8Buffer(underlyingBuffer, dataType, length, offset);
            }
        }
        throw new IllegalStateException("Unknown datatype used: [" + (Object)((Object)dataType) + "]");
    }

    @Override
    public DataBuffer create(DataBuffer underlyingBuffer, long offset, long length) {
        switch (underlyingBuffer.dataType()) {
            case DOUBLE: {
                return new CudaDoubleDataBuffer(underlyingBuffer, length, offset);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(underlyingBuffer, length, offset);
            }
            case HALF: {
                return new CudaHalfDataBuffer(underlyingBuffer, length, offset);
            }
            case BFLOAT16: {
                return new CudaBfloat16DataBuffer(underlyingBuffer, length, offset);
            }
            case UINT64: {
                return new CudaUInt64DataBuffer(underlyingBuffer, length, offset);
            }
            case LONG: {
                return new CudaLongDataBuffer(underlyingBuffer, length, offset);
            }
            case UINT32: {
                return new CudaUInt32DataBuffer(underlyingBuffer, length, offset);
            }
            case INT: {
                return new CudaIntDataBuffer(underlyingBuffer, length, offset);
            }
            case UINT16: {
                return new CudaUInt16DataBuffer(underlyingBuffer, length, offset);
            }
            case SHORT: {
                return new CudaShortDataBuffer(underlyingBuffer, length, offset);
            }
            case UBYTE: {
                return new CudaUByteDataBuffer(underlyingBuffer, length, offset);
            }
            case BYTE: {
                return new CudaByteDataBuffer(underlyingBuffer, length, offset);
            }
            case BOOL: {
                return new CudaBoolDataBuffer(underlyingBuffer, length, offset);
            }
            case UTF8: {
                return new CudaUtf8Buffer(underlyingBuffer, length, offset);
            }
        }
        throw new ND4JIllegalStateException("Unknown data buffer type: " + underlyingBuffer.dataType().toString());
    }

    @Override
    public DataBuffer createSame(DataBuffer buffer, boolean init) {
        switch (buffer.dataType()) {
            case INT: {
                return this.createInt(buffer.length(), init);
            }
            case FLOAT: {
                return this.createFloat(buffer.length(), init);
            }
            case DOUBLE: {
                return this.createDouble(buffer.length(), init);
            }
            case BFLOAT16: {
                return this.createBfloat16(buffer.length(), init);
            }
            case HALF: {
                return this.createHalf(buffer.length(), init);
            }
        }
        throw new UnsupportedOperationException("Unknown dataType: " + (Object)((Object)buffer.dataType()));
    }

    @Override
    public DataBuffer createSame(DataBuffer buffer, boolean init, MemoryWorkspace workspace) {
        switch (buffer.dataType()) {
            case INT: {
                return this.createInt(buffer.length(), init, workspace);
            }
            case FLOAT: {
                return this.createFloat(buffer.length(), init, workspace);
            }
            case DOUBLE: {
                return this.createDouble(buffer.length(), init, workspace);
            }
            case BFLOAT16: {
                return this.createBfloat16(buffer.length(), init, workspace);
            }
            case HALF: {
                return this.createHalf(buffer.length(), init, workspace);
            }
        }
        throw new UnsupportedOperationException("Unknown dataType: " + (Object)((Object)buffer.dataType()));
    }

    @Override
    public DataBuffer createFloat(float[] data, MemoryWorkspace workspace) {
        return this.createFloat(data, true, workspace);
    }

    @Override
    public DataBuffer createFloat(float[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaFloatDataBuffer(data, copy, workspace);
    }

    @Override
    public DataBuffer createInt(int[] data, MemoryWorkspace workspace) {
        return new CudaIntDataBuffer(data, workspace);
    }

    @Override
    public DataBuffer createInt(int[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaIntDataBuffer(data, copy, workspace);
    }

    @Override
    public DataBuffer createDouble(long offset, int length) {
        return new CudaDoubleDataBuffer((long)length, 8, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, int length) {
        return new CudaFloatDataBuffer((long)length, 4, (long)length);
    }

    @Override
    public DataBuffer createInt(long offset, int length) {
        return new CudaIntDataBuffer((long)length, 4, offset);
    }

    @Override
    public DataBuffer createDouble(long offset, int[] data) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, int[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createInt(long offset, int[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createDouble(long offset, double[] data) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createDouble(long offset, double[] data, MemoryWorkspace workspace) {
        return new CudaDoubleDataBuffer(data, true, offset, workspace);
    }

    @Override
    public DataBuffer createDouble(long offset, byte[] data, int length) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubleArray(data), true, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, byte[] data, int length) {
        return new CudaFloatDataBuffer(ArrayUtil.toDoubleArray(data), true, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, double[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createInt(long offset, double[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createDouble(long offset, float[] data) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, float[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, float[] data, MemoryWorkspace workspace) {
        return new CudaFloatDataBuffer(data, true, offset, workspace);
    }

    @Override
    public DataBuffer createInt(long offset, float[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createDouble(long offset, int[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, int[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createInt(long offset, int[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createDouble(long offset, double[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, double[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createInt(long offset, double[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createDouble(long offset, float[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createFloat(long offset, float[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createInt(long offset, float[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createDouble(long length) {
        return new CudaDoubleDataBuffer(length);
    }

    @Override
    public DataBuffer createDouble(long length, boolean initialize) {
        return new CudaDoubleDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createFloat(long length) {
        return new CudaFloatDataBuffer(length);
    }

    @Override
    public DataBuffer createFloat(long length, boolean initialize) {
        return new CudaFloatDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createFloat(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaFloatDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer create(DataType dataType, long length, boolean initialize) {
        switch (dataType) {
            case UINT16: {
                return new CudaUInt16DataBuffer(length, initialize);
            }
            case UINT32: {
                return new CudaUInt32DataBuffer(length, initialize);
            }
            case UINT64: {
                return new CudaUInt64DataBuffer(length, initialize);
            }
            case LONG: {
                return new CudaLongDataBuffer(length, initialize);
            }
            case INT: {
                return new CudaIntDataBuffer(length, initialize);
            }
            case SHORT: {
                return new CudaShortDataBuffer(length, initialize);
            }
            case UBYTE: {
                return new CudaUByteDataBuffer(length, initialize);
            }
            case BYTE: {
                return new CudaByteDataBuffer(length, initialize);
            }
            case DOUBLE: {
                return new CudaDoubleDataBuffer(length, initialize);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(length, initialize);
            }
            case BFLOAT16: {
                return new CudaBfloat16DataBuffer(length, initialize);
            }
            case HALF: {
                return new CudaHalfDataBuffer(length, initialize);
            }
            case BOOL: {
                return new CudaBoolDataBuffer(length, initialize);
            }
            case UTF8: {
                return new CudaUtf8Buffer(length, true);
            }
        }
        throw new UnsupportedOperationException("Unknown data type: [" + (Object)((Object)dataType) + "]");
    }

    @Override
    public DataBuffer create(DataType dataType, long length, boolean initialize, MemoryWorkspace workspace) {
        if (workspace == null) {
            return this.create(dataType, length, initialize);
        }
        switch (dataType) {
            case UINT16: {
                return new CudaUInt16DataBuffer(length, initialize, workspace);
            }
            case UINT32: {
                return new CudaUInt32DataBuffer(length, initialize, workspace);
            }
            case UINT64: {
                return new CudaUInt64DataBuffer(length, initialize, workspace);
            }
            case LONG: {
                return new CudaLongDataBuffer(length, initialize, workspace);
            }
            case INT: {
                return new CudaIntDataBuffer(length, initialize, workspace);
            }
            case SHORT: {
                return new CudaShortDataBuffer(length, initialize, workspace);
            }
            case UBYTE: {
                return new CudaUByteDataBuffer(length, initialize, workspace);
            }
            case BYTE: {
                return new CudaByteDataBuffer(length, initialize, workspace);
            }
            case DOUBLE: {
                return new CudaDoubleDataBuffer(length, initialize, workspace);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(length, initialize, workspace);
            }
            case HALF: {
                return new CudaHalfDataBuffer(length, initialize, workspace);
            }
            case BFLOAT16: {
                return new CudaBfloat16DataBuffer(length, initialize, workspace);
            }
            case BOOL: {
                return new CudaBoolDataBuffer(length, initialize, workspace);
            }
        }
        throw new UnsupportedOperationException("Unknown data type: [" + (Object)((Object)dataType) + "]");
    }

    @Override
    public DataBuffer createInt(long length) {
        return new CudaIntDataBuffer(length);
    }

    @Override
    public DataBuffer createBFloat16(long length) {
        return new CudaBfloat16DataBuffer(length);
    }

    @Override
    public DataBuffer createUInt(long length) {
        return new CudaUInt32DataBuffer(length);
    }

    @Override
    public DataBuffer createUShort(long length) {
        return new CudaUInt16DataBuffer(length);
    }

    @Override
    public DataBuffer createUByte(long length) {
        return new CudaUByteDataBuffer(length);
    }

    @Override
    public DataBuffer createULong(long length) {
        return new CudaUInt64DataBuffer(length);
    }

    @Override
    public DataBuffer createBool(long length) {
        return new CudaBoolDataBuffer(length);
    }

    @Override
    public DataBuffer createShort(long length) {
        return new CudaShortDataBuffer(length);
    }

    @Override
    public DataBuffer createByte(long length) {
        return new CudaByteDataBuffer(length);
    }

    @Override
    public DataBuffer createBFloat16(long length, boolean initialize) {
        return new CudaBfloat16DataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createUInt(long length, boolean initialize) {
        return new CudaUInt32DataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createUShort(long length, boolean initialize) {
        return new CudaUInt16DataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createUByte(long length, boolean initialize) {
        return new CudaUByteDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createULong(long length, boolean initialize) {
        return new CudaUInt64DataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createBool(long length, boolean initialize) {
        return new CudaBoolDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createShort(long length, boolean initialize) {
        return new CudaShortDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createByte(long length, boolean initialize) {
        return new CudaByteDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createBFloat16(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaBfloat16DataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createUInt(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaUInt32DataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createUShort(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaUInt16DataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createUByte(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaUByteDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createULong(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaUInt64DataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createBool(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaBoolDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createShort(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaShortDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createByte(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaByteDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createInt(long length, boolean initialize) {
        return new CudaIntDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createInt(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaIntDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createDouble(int[] data) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles(data));
    }

    @Override
    public DataBuffer createFloat(int[] data) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats(data));
    }

    @Override
    public DataBuffer createInt(int[] data) {
        return new CudaIntDataBuffer(data);
    }

    @Override
    public DataBuffer createDouble(double[] data) {
        return new CudaDoubleDataBuffer(data);
    }

    @Override
    public DataBuffer createFloat(double[] data) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats(data));
    }

    @Override
    public DataBuffer createInt(double[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts(data));
    }

    @Override
    public DataBuffer createDouble(float[] data) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles(data));
    }

    @Override
    public DataBuffer createFloat(float[] data) {
        return new CudaFloatDataBuffer(data);
    }

    @Override
    public DataBuffer createInt(float[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts(data));
    }

    @Override
    public DataBuffer createDouble(int[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDouble(data));
    }

    @Override
    public DataBuffer createFloat(int[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats(data));
    }

    @Override
    public DataBuffer createInt(int[] data, boolean copy) {
        return new CudaIntDataBuffer(data);
    }

    @Override
    public DataBuffer createLong(int[] data, boolean copy) {
        return new CudaLongDataBuffer(data);
    }

    @Override
    public DataBuffer createDouble(double[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data);
    }

    @Override
    public DataBuffer createFloat(double[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats(data));
    }

    @Override
    public DataBuffer createInt(double[] data, boolean copy) {
        return new CudaIntDataBuffer(ArrayUtil.toInts(data));
    }

    @Override
    public DataBuffer createDouble(float[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles(data));
    }

    @Override
    public DataBuffer createFloat(float[] data, boolean copy) {
        return new CudaFloatDataBuffer(data);
    }

    @Override
    public DataBuffer createInt(float[] data, boolean copy) {
        return new CudaIntDataBuffer(ArrayUtil.toInts(data));
    }

    @Override
    public DataBuffer createDouble(long[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles(data));
    }

    @Override
    public DataBuffer createFloat(long[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats(data));
    }

    @Override
    public DataBuffer createInt(long[] data, boolean copy) {
        return new CudaIntDataBuffer(data);
    }

    @Override
    public DataBuffer create(Pointer pointer, DataType type, long length, Indexer indexer) {
        switch (type) {
            case UINT64: {
                return new CudaUInt64DataBuffer(pointer, indexer, length);
            }
            case LONG: {
                return new CudaLongDataBuffer(pointer, indexer, length);
            }
            case UINT32: {
                return new CudaUInt32DataBuffer(pointer, indexer, length);
            }
            case INT: {
                return new CudaIntDataBuffer(pointer, indexer, length);
            }
            case UINT16: {
                return new CudaUInt16DataBuffer(pointer, indexer, length);
            }
            case SHORT: {
                return new CudaShortDataBuffer(pointer, indexer, length);
            }
            case UBYTE: {
                return new CudaUByteDataBuffer(pointer, indexer, length);
            }
            case BYTE: {
                return new CudaByteDataBuffer(pointer, indexer, length);
            }
            case DOUBLE: {
                return new CudaDoubleDataBuffer(pointer, indexer, length);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(pointer, indexer, length);
            }
            case HALF: {
                return new CudaHalfDataBuffer(pointer, indexer, length);
            }
            case BFLOAT16: {
                return new CudaBfloat16DataBuffer(pointer, indexer, length);
            }
            case BOOL: {
                return new CudaBoolDataBuffer(pointer, indexer, length);
            }
        }
        throw new IllegalArgumentException("Illegal dtype " + (Object)((Object)type));
    }

    @Override
    public DataBuffer create(Pointer pointer, Pointer specialPointer, DataType type, long length, Indexer indexer) {
        switch (type) {
            case UINT64: {
                return new CudaUInt64DataBuffer(pointer, specialPointer, indexer, length);
            }
            case LONG: {
                return new CudaLongDataBuffer(pointer, specialPointer, indexer, length);
            }
            case UINT32: {
                return new CudaUInt32DataBuffer(pointer, specialPointer, indexer, length);
            }
            case INT: {
                return new CudaIntDataBuffer(pointer, specialPointer, indexer, length);
            }
            case UINT16: {
                return new CudaUInt16DataBuffer(pointer, specialPointer, indexer, length);
            }
            case SHORT: {
                return new CudaShortDataBuffer(pointer, specialPointer, indexer, length);
            }
            case UBYTE: {
                return new CudaUByteDataBuffer(pointer, specialPointer, indexer, length);
            }
            case BYTE: {
                return new CudaByteDataBuffer(pointer, specialPointer, indexer, length);
            }
            case DOUBLE: {
                return new CudaDoubleDataBuffer(pointer, specialPointer, indexer, length);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(pointer, specialPointer, indexer, length);
            }
            case HALF: {
                return new CudaHalfDataBuffer(pointer, specialPointer, indexer, length);
            }
            case BFLOAT16: {
                return new CudaBfloat16DataBuffer(pointer, specialPointer, indexer, length);
            }
            case BOOL: {
                return new CudaBoolDataBuffer(pointer, specialPointer, indexer, length);
            }
        }
        throw new IllegalArgumentException("Illegal dtype " + (Object)((Object)type));
    }

    @Override
    public DataBuffer create(DoublePointer doublePointer, long length) {
        return new CudaDoubleDataBuffer(doublePointer, DoubleIndexer.create(doublePointer), length);
    }

    @Override
    public DataBuffer create(IntPointer intPointer, long length) {
        return new CudaIntDataBuffer(intPointer, IntIndexer.create(intPointer), length);
    }

    @Override
    public DataBuffer create(FloatPointer floatPointer, long length) {
        return new CudaFloatDataBuffer(floatPointer, FloatIndexer.create(floatPointer), length);
    }

    @Override
    public DataBuffer createHalf(long length) {
        return new CudaHalfDataBuffer(length);
    }

    @Override
    public DataBuffer createHalf(long length, boolean initialize) {
        return new CudaHalfDataBuffer(length, initialize);
    }

    public DataBuffer createBfloat16(long length, boolean initialize) {
        return new CudaBfloat16DataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createHalf(float[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    @Override
    public DataBuffer createHalf(double[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    @Override
    public DataBuffer createHalf(long offset, double[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createHalf(long offset, float[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createHalf(long offset, int[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createHalf(long offset, double[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createHalf(long offset, float[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createHalf(long offset, float[] data, MemoryWorkspace workspace) {
        return new CudaHalfDataBuffer(data, true, offset, workspace);
    }

    @Override
    public DataBuffer createHalf(long offset, int[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createHalf(long offset, byte[] data, boolean copy) {
        return new CudaHalfDataBuffer(ArrayUtil.toFloatArray(data), copy, offset);
    }

    @Override
    public DataBuffer createHalf(int[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    @Override
    public DataBuffer createHalf(float[] data) {
        return new CudaHalfDataBuffer(data);
    }

    @Override
    public DataBuffer createHalf(double[] data) {
        return new CudaHalfDataBuffer(data);
    }

    @Override
    public DataBuffer createHalf(int[] data) {
        return new CudaHalfDataBuffer(data);
    }

    @Override
    public DataBuffer createHalf(long offset, int length) {
        return new CudaHalfDataBuffer(length);
    }

    @Override
    public DataBuffer createDouble(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaDoubleDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createDouble(double[] data, MemoryWorkspace workspace) {
        return this.createDouble(data, true, workspace);
    }

    @Override
    public DataBuffer createDouble(double[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaDoubleDataBuffer(data, copy, workspace);
    }

    @Override
    public DataBuffer createHalf(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaHalfDataBuffer(length, initialize, workspace);
    }

    public DataBuffer createBfloat16(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaBfloat16DataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createHalf(float[] data, MemoryWorkspace workspace) {
        return this.createHalf(data, true, workspace);
    }

    @Override
    public DataBuffer createHalf(float[] data, boolean copy, MemoryWorkspace workspace) {
        return new CudaHalfDataBuffer(data, copy, workspace);
    }

    @Override
    public Class<? extends DataBuffer> intBufferClass() {
        return CudaIntDataBuffer.class;
    }

    @Override
    public Class<? extends DataBuffer> longBufferClass() {
        return CudaLongDataBuffer.class;
    }

    @Override
    public Class<? extends DataBuffer> halfBufferClass() {
        return CudaHalfDataBuffer.class;
    }

    @Override
    public Class<? extends DataBuffer> floatBufferClass() {
        return CudaFloatDataBuffer.class;
    }

    @Override
    public Class<? extends DataBuffer> doubleBufferClass() {
        return CudaDoubleDataBuffer.class;
    }

    @Override
    public DataBuffer createLong(long[] data) {
        return this.createLong(data, true);
    }

    @Override
    public DataBuffer createLong(long[] data, boolean copy) {
        return new CudaLongDataBuffer(data, copy);
    }

    @Override
    public DataBuffer createLong(long[] data, MemoryWorkspace workspace) {
        return new CudaLongDataBuffer(data, workspace);
    }

    @Override
    public DataBuffer createLong(long length) {
        return this.createLong(length, true);
    }

    @Override
    public DataBuffer createLong(long length, boolean initialize) {
        return new CudaLongDataBuffer(length, initialize);
    }

    @Override
    public DataBuffer createLong(long length, boolean initialize, MemoryWorkspace workspace) {
        return new CudaLongDataBuffer(length, initialize, workspace);
    }

    @Override
    public DataBuffer createUtf8Buffer(byte[] data, long product) {
        return new CudaUtf8Buffer(data, product);
    }
}

