/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.ops.executioner;

import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.common.primitives.Pair;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cudaStream_t;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOpContext;
import org.nd4j.linalg.api.ops.ExecutionMode;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.nd4j.linalg.jcublas.ops.executioner.CudaOpContextDeallocator;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueContext;
import org.nd4j.nativeblas.OpaqueRandomGenerator;

public class CudaOpContext
extends BaseOpContext
implements OpContext,
Deallocatable {
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private OpaqueContext context = this.nativeOps.createGraphContext(1);
    private final transient long id = Nd4j.getDeallocatorService().nextValue();

    public CudaOpContext() {
        Nd4j.getDeallocatorService().pickObject(this);
    }

    @Override
    public void close() {
    }

    @Override
    public void setIArguments(long ... arguments) {
        if (arguments.length > 0) {
            super.setIArguments(arguments);
            this.nativeOps.setGraphContextIArguments(this.context, new LongPointer(arguments), arguments.length);
        }
    }

    @Override
    public void setBArguments(boolean ... arguments) {
        if (arguments.length > 0) {
            super.setBArguments(arguments);
            this.nativeOps.setGraphContextBArguments(this.context, new BooleanPointer(arguments), arguments.length);
        }
    }

    @Override
    public void setTArguments(double ... arguments) {
        if (arguments.length > 0) {
            super.setTArguments(arguments);
            this.nativeOps.setGraphContextTArguments(this.context, new DoublePointer(arguments), arguments.length);
        }
    }

    @Override
    public void setDArguments(DataType ... arguments) {
        if (arguments.length > 0) {
            super.setDArguments(arguments);
            int[] args = new int[arguments.length];
            for (int e = 0; e < arguments.length; ++e) {
                args[e] = arguments[e].toInt();
            }
            this.nativeOps.setGraphContextDArguments(this.context, new IntPointer(args), arguments.length);
        }
    }

    @Override
    public void setRngStates(long rootState, long nodeState) {
        this.nativeOps.setRandomGeneratorStates(this.nativeOps.getGraphContextRandomGenerator(this.context), rootState, nodeState);
    }

    @Override
    public Pair<Long, Long> getRngStates() {
        OpaqueRandomGenerator g = this.nativeOps.getGraphContextRandomGenerator(this.context);
        return Pair.makePair(this.nativeOps.getRandomGeneratorRootState(g), this.nativeOps.getRandomGeneratorNodeState(g));
    }

    @Override
    public void setInputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.nativeOps.setGraphContextInputBuffer(this.context, index, array.isEmpty() ? null : ((BaseCudaDataBuffer)array.data()).getOpaqueDataBuffer(), array.shapeInfoDataBuffer().addressPointer(), AtomicAllocator.getInstance().getPointer(array.shapeInfoDataBuffer()));
        super.setInputArray(index, array);
    }

    @Override
    public void setOutputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.nativeOps.setGraphContextOutputBuffer(this.context, index, array.isEmpty() ? null : ((BaseCudaDataBuffer)array.data()).getOpaqueDataBuffer(), array.shapeInfoDataBuffer().addressPointer(), AtomicAllocator.getInstance().getPointer(array.shapeInfoDataBuffer()));
        super.setOutputArray(index, array);
    }

    @Override
    public Pointer contextPointer() {
        return this.context;
    }

    public void setCudaStream(cudaStream_t stream, Pointer reductionPointer, Pointer allocationPointer) {
        this.nativeOps.setGraphContextCudaContext(this.context, stream, reductionPointer, allocationPointer);
    }

    @Override
    public void markInplace(boolean reallyInplace) {
        this.nativeOps.markGraphContextInplace(this.context, reallyInplace);
    }

    @Override
    public void allowHelpers(boolean reallyAllow) {
        this.nativeOps.ctxAllowHelpers(this.context, reallyAllow);
    }

    @Override
    public void shapeFunctionOverride(boolean reallyOverride) {
        this.nativeOps.ctxShapeFunctionOverride(this.context, reallyOverride);
    }

    @Override
    public void setExecutionMode(@NonNull ExecutionMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        super.setExecutionMode(mode);
        this.nativeOps.ctxSetExecutionMode(this.context, mode.ordinal());
    }

    @Override
    public void purge() {
        super.purge();
        this.nativeOps.ctxPurge(this.context);
    }

    @Override
    public String getUniqueId() {
        return new String("CTX_" + this.id);
    }

    @Override
    public Deallocator deallocator() {
        return new CudaOpContextDeallocator(this);
    }

    @Override
    public int targetDevice() {
        return 0;
    }
}

