/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.function.BiFunction;
import org.nd4j.common.primitives.Triple;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class ND4JTestUtils {
    private ND4JTestUtils() {
    }

    public static ComparisonResult validateSerializedArrays(File dir1, File dir2, boolean recursive) throws Exception {
        return ND4JTestUtils.validateSerializedArrays(dir1, dir2, recursive, new EqualsFn());
    }

    public static ComparisonResult validateSerializedArrays(File dir1, File dir2, boolean recursive, BiFunction<INDArray, INDArray, Boolean> evalFn) throws Exception {
        String relative;
        File[] f1 = FileUtils.listFiles(dir1, null, recursive).toArray(new File[0]);
        File[] f2 = FileUtils.listFiles(dir2, null, recursive).toArray(new File[0]);
        Preconditions.checkState(f1.length > 0, "No files found for directory 1: %s", (Object)dir1.getAbsolutePath());
        Preconditions.checkState(f2.length > 0, "No files found for directory 2: %s", (Object)dir2.getAbsolutePath());
        HashMap<String, File> relativized1 = new HashMap<String, File>();
        HashMap<String, File> relativized2 = new HashMap<String, File>();
        URI u = dir1.toURI();
        for (File f : f1) {
            if (!f.isFile()) continue;
            relative = u.relativize(f.toURI()).getPath();
            relativized1.put(relative, f);
        }
        u = dir2.toURI();
        for (File f : f2) {
            if (!f.isFile()) continue;
            relative = u.relativize(f.toURI()).getPath();
            relativized2.put(relative, f);
        }
        ArrayList<File> skipped1 = new ArrayList<File>();
        for (String s : relativized1.keySet()) {
            if (relativized2.containsKey(s)) continue;
            skipped1.add((File)relativized1.get(s));
        }
        ArrayList<File> skipped2 = new ArrayList<File>();
        for (String s : relativized2.keySet()) {
            if (relativized1.containsKey(s)) continue;
            skipped2.add((File)relativized1.get(s));
        }
        ArrayList<Triple<File, File, Boolean>> allResults = new ArrayList<Triple<File, File, Boolean>>();
        ArrayList<Triple<File, File, Boolean>> passed = new ArrayList<Triple<File, File, Boolean>>();
        ArrayList<Triple<File, File, Boolean>> failed = new ArrayList<Triple<File, File, Boolean>>();
        for (Map.Entry e : relativized1.entrySet()) {
            File file1 = (File)e.getValue();
            File file2 = (File)relativized2.get(e.getKey());
            if (file2 == null) continue;
            INDArray i1 = Nd4j.readBinary(file1);
            INDArray i2 = Nd4j.readBinary(file2);
            boolean b = evalFn.apply(i1, i2);
            Triple<File, File, Boolean> t = new Triple<File, File, Boolean>(file1, file2, b);
            allResults.add(t);
            if (b) {
                passed.add(t);
                continue;
            }
            failed.add(t);
        }
        Comparator<Triple<File, File, Boolean>> c = new Comparator<Triple<File, File, Boolean>>(){

            @Override
            public int compare(Triple<File, File, Boolean> o1, Triple<File, File, Boolean> o2) {
                return o1.getFirst().compareTo(o2.getFirst());
            }
        };
        Collections.sort(allResults, c);
        Collections.sort(passed, c);
        Collections.sort(failed, c);
        Collections.sort(skipped1);
        Collections.sort(skipped2);
        return new ComparisonResult(allResults, passed, failed, skipped1, skipped2);
    }

    public static class EqualsWithEpsFn
    implements BiFunction<INDArray, INDArray, Boolean> {
        private final double eps;

        @Override
        public Boolean apply(INDArray i1, INDArray i2) {
            return i1.equalsWithEps(i2, this.eps);
        }

        public EqualsWithEpsFn(double eps) {
            this.eps = eps;
        }
    }

    public static class EqualsFn
    implements BiFunction<INDArray, INDArray, Boolean> {
        @Override
        public Boolean apply(INDArray i1, INDArray i2) {
            return i1.equals(i2);
        }
    }

    public static class ComparisonResult {
        List<Triple<File, File, Boolean>> allResults;
        List<Triple<File, File, Boolean>> passed;
        List<Triple<File, File, Boolean>> failed;
        List<File> skippedDir1;
        List<File> skippedDir2;

        public ComparisonResult(List<Triple<File, File, Boolean>> allResults, List<Triple<File, File, Boolean>> passed, List<Triple<File, File, Boolean>> failed, List<File> skippedDir1, List<File> skippedDir2) {
            this.allResults = allResults;
            this.passed = passed;
            this.failed = failed;
            this.skippedDir1 = skippedDir1;
            this.skippedDir2 = skippedDir2;
        }

        public List<Triple<File, File, Boolean>> getAllResults() {
            return this.allResults;
        }

        public List<Triple<File, File, Boolean>> getPassed() {
            return this.passed;
        }

        public List<Triple<File, File, Boolean>> getFailed() {
            return this.failed;
        }

        public List<File> getSkippedDir1() {
            return this.skippedDir1;
        }

        public List<File> getSkippedDir2() {
            return this.skippedDir2;
        }

        public void setAllResults(List<Triple<File, File, Boolean>> allResults) {
            this.allResults = allResults;
        }

        public void setPassed(List<Triple<File, File, Boolean>> passed) {
            this.passed = passed;
        }

        public void setFailed(List<Triple<File, File, Boolean>> failed) {
            this.failed = failed;
        }

        public void setSkippedDir1(List<File> skippedDir1) {
            this.skippedDir1 = skippedDir1;
        }

        public void setSkippedDir2(List<File> skippedDir2) {
            this.skippedDir2 = skippedDir2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparisonResult)) {
                return false;
            }
            ComparisonResult other = (ComparisonResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Triple<File, File, Boolean>> this$allResults = this.getAllResults();
            List<Triple<File, File, Boolean>> other$allResults = other.getAllResults();
            if (this$allResults == null ? other$allResults != null : !((Object)this$allResults).equals(other$allResults)) {
                return false;
            }
            List<Triple<File, File, Boolean>> this$passed = this.getPassed();
            List<Triple<File, File, Boolean>> other$passed = other.getPassed();
            if (this$passed == null ? other$passed != null : !((Object)this$passed).equals(other$passed)) {
                return false;
            }
            List<Triple<File, File, Boolean>> this$failed = this.getFailed();
            List<Triple<File, File, Boolean>> other$failed = other.getFailed();
            if (this$failed == null ? other$failed != null : !((Object)this$failed).equals(other$failed)) {
                return false;
            }
            List<File> this$skippedDir1 = this.getSkippedDir1();
            List<File> other$skippedDir1 = other.getSkippedDir1();
            if (this$skippedDir1 == null ? other$skippedDir1 != null : !((Object)this$skippedDir1).equals(other$skippedDir1)) {
                return false;
            }
            List<File> this$skippedDir2 = this.getSkippedDir2();
            List<File> other$skippedDir2 = other.getSkippedDir2();
            return !(this$skippedDir2 == null ? other$skippedDir2 != null : !((Object)this$skippedDir2).equals(other$skippedDir2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComparisonResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Triple<File, File, Boolean>> $allResults = this.getAllResults();
            result = result * 59 + ($allResults == null ? 43 : ((Object)$allResults).hashCode());
            List<Triple<File, File, Boolean>> $passed = this.getPassed();
            result = result * 59 + ($passed == null ? 43 : ((Object)$passed).hashCode());
            List<Triple<File, File, Boolean>> $failed = this.getFailed();
            result = result * 59 + ($failed == null ? 43 : ((Object)$failed).hashCode());
            List<File> $skippedDir1 = this.getSkippedDir1();
            result = result * 59 + ($skippedDir1 == null ? 43 : ((Object)$skippedDir1).hashCode());
            List<File> $skippedDir2 = this.getSkippedDir2();
            result = result * 59 + ($skippedDir2 == null ? 43 : ((Object)$skippedDir2).hashCode());
            return result;
        }

        public String toString() {
            return "ND4JTestUtils.ComparisonResult(allResults=" + this.getAllResults() + ", passed=" + this.getPassed() + ", failed=" + this.getFailed() + ", skippedDir1=" + this.getSkippedDir1() + ", skippedDir2=" + this.getSkippedDir2() + ")";
        }
    }
}

